"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReporterFilter = exports.getAssigneeFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReporterFilter = ({
  currentUserProfile,
  currentUser,
  isLoadingCurrentUserProfile,
  recentCasesFilterBy
}) => {
  const emptyReportersFilter = {
    reporters: []
  };
  if (recentCasesFilterBy !== 'myRecentlyReported') {
    return emptyReportersFilter;
  }
  if (currentUserProfile != null && !isLoadingCurrentUserProfile) {
    return {
      reporters: [{
        email: currentUserProfile.user.email,
        full_name: currentUserProfile.user.full_name,
        username: currentUserProfile.user.username,
        profile_uid: currentUserProfile.uid
      }]
    };
  } else if (currentUser != null) {
    return {
      reporters: [{
        email: currentUser.email,
        full_name: currentUser.fullName,
        username: currentUser.username
      }]
    };
  }
  return emptyReportersFilter;
};
exports.getReporterFilter = getReporterFilter;
const getAssigneeFilter = ({
  currentUserProfile,
  isLoadingCurrentUserProfile
}) => {
  const emptyAssigneesFilter = {
    assignees: []
  };
  if (currentUserProfile != null && !isLoadingCurrentUserProfile) {
    return {
      assignees: [currentUserProfile.uid]
    };
  }
  return emptyAssigneesFilter;
};
exports.getAssigneeFilter = getAssigneeFilter;