"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservableActionsPopoverButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
var _delete_attachment_confirmation_modal = require("../user_actions/delete_attachment_confirmation_modal");
var _use_delete_property_action = require("../user_actions/property_actions/use_delete_property_action");
var _edit_observable_modal = require("./edit_observable_modal");
var _use_delete_observables = require("../../containers/use_delete_observables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservableActionsPopoverButton = ({
  caseData,
  observable
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [showEditModal, setShowEditModal] = (0, _react.useState)(false);
  const {
    isLoading: isDeleteLoading,
    mutateAsync: deleteObservable
  } = (0, _use_delete_observables.useDeleteObservable)(caseData.id, observable.id);
  const isLoading = isDeleteLoading;
  const {
    showDeletionModal,
    onModalOpen: onDeletionModalOpen,
    onConfirm,
    onCancel
  } = (0, _use_delete_property_action.useDeletePropertyAction)({
    onDelete: () => {
      deleteObservable();
    }
  });
  const tooglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prevValue => !prevValue), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const panels = (0, _react.useMemo)(() => {
    const mainPanelItems = [];
    const panelsToBuild = [{
      id: 0,
      title: i18n.OBSERVABLE_ACTIONS,
      items: mainPanelItems
    }];
    if (permissions.update) {
      mainPanelItems.push({
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: 'danger'
        }, i18n.DELETE_OBSERVABLE),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "trash",
          size: "m",
          color: 'danger'
        }),
        onClick: () => {
          closePopover();
          onDeletionModalOpen();
        },
        disabled: isLoading,
        'data-test-subj': 'cases-observables-delete-button'
      });
      mainPanelItems.push({
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, null, i18n.EDIT_OBSERVABLE),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "pencil",
          size: "m"
        }),
        onClick: () => {
          setShowEditModal(true);
          closePopover();
        },
        disabled: isLoading,
        'data-test-subj': 'cases-observables-edit-button'
      });
    }
    return panelsToBuild;
  }, [closePopover, isLoading, onDeletionModalOpen, permissions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `cases-observables-popover-${observable.id}`,
    key: `cases-observables-popover-${observable.id}`,
    "data-test-subj": `cases-observables-popover-${observable.id}`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: tooglePopover,
      iconType: "boxesHorizontal",
      "aria-label": i18n.OBSERVABLE_ACTIONS,
      color: "text",
      key: `cases-observables-actions-popover-button-${observable.id}`,
      "data-test-subj": `cases-observables-actions-popover-button-${observable.id}`
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": 'cases-observables-popover-context-menu'
  })), showDeletionModal && /*#__PURE__*/_react.default.createElement(_delete_attachment_confirmation_modal.DeleteAttachmentConfirmationModal, {
    title: i18n.DELETE_OBSERVABLE_CONFIRM,
    confirmButtonText: i18n.DELETE_OBSERVABLE,
    onCancel: onCancel,
    onConfirm: onConfirm
  }), showEditModal && /*#__PURE__*/_react.default.createElement(_edit_observable_modal.EditObservableModal, {
    caseData: caseData,
    observable: observable,
    onCloseModal: () => setShowEditModal(false)
  }));
};
exports.ObservableActionsPopoverButton = ObservableActionsPopoverButton;
ObservableActionsPopoverButton.displayName = 'FileActionsPopoverButton';