"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  TITLE: true,
  DESCRIPTION: true,
  NO_OBSERVABLE_TYPES: true,
  ADD_OBSERVABLE_TYPE: true,
  OBSERVABLE_TYPE_LABEL: true,
  REQUIRED_FIELD: true,
  DELETE_OBSERVABLE_TYPE_TITLE: true,
  DELETE_OBSERVABLE_TYPE_DESCRIPTION: true,
  DELETE: true,
  MAX_OBSERVABLE_TYPES_LIMIT: true
};
exports.TITLE = exports.REQUIRED_FIELD = exports.OBSERVABLE_TYPE_LABEL = exports.NO_OBSERVABLE_TYPES = exports.MAX_OBSERVABLE_TYPES_LIMIT = exports.DESCRIPTION = exports.DELETE_OBSERVABLE_TYPE_TITLE = exports.DELETE_OBSERVABLE_TYPE_DESCRIPTION = exports.DELETE = exports.ADD_OBSERVABLE_TYPE = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.cases.observableTypes.title', {
  defaultMessage: 'Observable types'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.cases.observableTypes.description', {
  defaultMessage: 'Add observable types for customized case collaboration.'
});
const NO_OBSERVABLE_TYPES = exports.NO_OBSERVABLE_TYPES = _i18n.i18n.translate('xpack.cases.observableTypes.noObservableTypes', {
  defaultMessage: 'You do not have any observable types yet'
});
const ADD_OBSERVABLE_TYPE = exports.ADD_OBSERVABLE_TYPE = _i18n.i18n.translate('xpack.cases.observableTypes.addObservableType', {
  defaultMessage: 'Add observable type'
});
const OBSERVABLE_TYPE_LABEL = exports.OBSERVABLE_TYPE_LABEL = _i18n.i18n.translate('xpack.cases.observableTypes.fieldLabel', {
  defaultMessage: 'Observable type label'
});
const REQUIRED_FIELD = fieldName => _i18n.i18n.translate('xpack.cases.observableTypes.requiredField', {
  values: {
    fieldName
  },
  defaultMessage: '{fieldName} is required.'
});
exports.REQUIRED_FIELD = REQUIRED_FIELD;
const DELETE_OBSERVABLE_TYPE_TITLE = fieldName => _i18n.i18n.translate('xpack.cases.observableTypes.deleteField', {
  values: {
    fieldName
  },
  defaultMessage: 'Delete observable type "{fieldName}"?'
});
exports.DELETE_OBSERVABLE_TYPE_TITLE = DELETE_OBSERVABLE_TYPE_TITLE;
const DELETE_OBSERVABLE_TYPE_DESCRIPTION = exports.DELETE_OBSERVABLE_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.cases.observableTypes.deleteObservableTypeDescription', {
  defaultMessage: 'The observable type will be removed from all cases and data will be lost.'
});
const DELETE = exports.DELETE = _i18n.i18n.translate('xpack.cases.observableTypes.options.Delete', {
  defaultMessage: 'Delete'
});
const MAX_OBSERVABLE_TYPES_LIMIT = maxObservableTypesLimit => _i18n.i18n.translate('xpack.cases.observableTypes.maxObservableTypesLimit', {
  values: {
    maxObservableTypesLimit
  },
  defaultMessage: 'Maximum number of {maxObservableTypesLimit} observable types reached.'
});
exports.MAX_OBSERVABLE_TYPES_LIMIT = MAX_OBSERVABLE_TYPES_LIMIT;