"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldsForm = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _schema = require("./schema");
var _form_fields = require("./form_fields");
var _domain = require("../../../common/types/domain");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormComponent = ({
  onChange,
  initialValue
}) => {
  const keyDefaultValue = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialValue !== null && initialValue !== void 0 ? initialValue : {
      key: keyDefaultValue,
      label: '',
      type: _domain.CustomFieldTypes.TEXT,
      required: false
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    serializer: _utils.customFieldSerializer
  });
  const {
    submit,
    isValid,
    isSubmitting
  } = form;
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid,
        submit
      });
    }
  }, [onChange, isValid, submit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_form_fields.FormFields, {
    isSubmitting: isSubmitting,
    isEditMode: Boolean(initialValue)
  }));
};
FormComponent.displayName = 'CustomFieldsForm';
const CustomFieldsForm = exports.CustomFieldsForm = /*#__PURE__*/_react.default.memo(FormComponent);