"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getManualAlertIds = void 0;
var _domain = require("../../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getManualAlertIds = comments => {
  const dedupeAlerts = comments.reduce((alertIds, comment) => {
    if (comment.type === _domain.AttachmentType.alert) {
      const ids = Array.isArray(comment.alertId) ? comment.alertId : [comment.alertId];
      ids.forEach(id => alertIds.add(id));
      return alertIds;
    }
    return alertIds;
  }, new Set());
  return Array.from(dedupeAlerts);
};
exports.getManualAlertIds = getManualAlertIds;