"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allCasesUrlStateSerializer = void 0;
var _lodash = require("lodash");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allCasesUrlStateSerializer = state => {
  var _state$filterOptions$;
  const supportedFilterOptions = (0, _lodash.pick)(state.filterOptions, ['search', 'severity', 'status', 'tags', 'assignees', 'category']);
  const customFieldsAsQueryParams = Object.entries(state.filterOptions.customFields).reduce((acc, [key, value]) => {
    if ((0, _lodash.isEmpty)(value.options)) {
      return acc;
    }
    return {
      ...acc,
      [key]: value.options
    };
  }, {});
  const combinedState = {
    ...state.queryParams,
    page: state.queryParams.page,
    perPage: state.queryParams.perPage,
    ...supportedFilterOptions,
    assignees: supportedFilterOptions.assignees.map(assignee => assignee === null ? _constants.NO_ASSIGNEES_FILTERING_KEYWORD : assignee),
    customFields: customFieldsAsQueryParams,
    search: encodeURIComponent((_state$filterOptions$ = state.filterOptions.search) !== null && _state$filterOptions$ !== void 0 ? _state$filterOptions$ : '')
  };

  // filters empty values
  return Object.entries(combinedState).reduce((acc, [key, value]) => {
    // isEmpty returns true for numbers
    if ((0, _lodash.isEmpty)(value) && !(0, _lodash.isNumber)(value)) {
      return acc;
    }
    return Object.assign(acc, {
      [key]: value
    });
  }, {});
};
exports.allCasesUrlStateSerializer = allCasesUrlStateSerializer;