"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaServices = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class KibanaServices {
  static init({
    application,
    config,
    http,
    serverless,
    kibanaVersion,
    ...startServices
  }) {
    this.services = {
      application,
      http,
      serverless,
      ...startServices
    };
    this.kibanaVersion = kibanaVersion;
    this.config = config;
  }
  static get() {
    if (!this.services) {
      this.throwUninitializedError();
    }
    return this.services;
  }
  static getKibanaVersion() {
    if (!this.kibanaVersion) {
      this.throwUninitializedError();
    }
    return this.kibanaVersion;
  }
  static getConfig() {
    return this.config;
  }
  static throwUninitializedError() {
    throw new Error('Kibana services not initialized - are you trying to import this module from outside of the Cases app?');
  }
}
exports.KibanaServices = KibanaServices;
(0, _defineProperty2.default)(KibanaServices, "kibanaVersion", void 0);
(0, _defineProperty2.default)(KibanaServices, "services", void 0);
(0, _defineProperty2.default)(KibanaServices, "config", void 0);