"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderFunctions = exports.renderFunctionNames = void 0;
var _image = require("../canvas_plugin_src/renderers/image");
var _error = require("../canvas_plugin_src/renderers/error");
var _debug = require("../canvas_plugin_src/renderers/debug");
var _markdown = require("../canvas_plugin_src/renderers/markdown");
var _metric = require("../canvas_plugin_src/renderers/metric");
var _pie = require("../canvas_plugin_src/renderers/pie");
var _plot = require("../canvas_plugin_src/renderers/plot");
var _progress = require("../canvas_plugin_src/renderers/progress");
var _repeat_image = require("../canvas_plugin_src/renderers/repeat_image");
var _reveal_image = require("../canvas_plugin_src/renderers/reveal_image");
var _shape = require("../canvas_plugin_src/renderers/shape");
var _text = require("../canvas_plugin_src/renderers/text");
var _table = require("../canvas_plugin_src/renderers/table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * FIXME: Render function factories require stateful dependencies to be
 * injected. Without them, we can not provide proper theming, i18n, or
 * telemetry when fatal errors occur during rendering.
 */
const unboxFactory = factory => factory();
const renderFunctionsFactories = [_debug.getDebugRenderer, _error.getErrorRenderer, _image.getImageRenderer, _markdown.getMarkdownRenderer, _metric.getMetricRenderer, _progress.getProgressRenderer, _reveal_image.getRevealImageRenderer, _repeat_image.getRepeatImageRenderer, _shape.getShapeRenderer, _text.getTextRenderer, _table.getTableRenderer];

/**
 * This is a collection of renderers which are bundled with the runtime.  If
 * a renderer is not listed here, but is used by the Shared Workpad, it will
 * not render.  This includes any plugins.
 */
const renderFunctions = exports.renderFunctions = [_pie.pie, _plot.plot, ...renderFunctionsFactories.map(unboxFactory)];
const renderFunctionNames = exports.renderFunctionNames = [...renderFunctions.map(fn => fn().name)];