"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "BorderStyle", {
  enumerable: true,
  get: function () {
    return _border_form.BorderStyle;
  }
});
exports.ExtendedTemplate = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _border_form = require("./border_form");
var _appearance_form = require("./appearance_form");
var _i18n = require("../../../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  ContainerStyle: strings
} = _i18n.ArgTypesStrings;
const ExtendedTemplate = ({
  getArgValue,
  setArgValue,
  workpad
}) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxxs",
  textTransform: "uppercase"
}, /*#__PURE__*/_react.default.createElement("h6", null, strings.getAppearanceTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_appearance_form.AppearanceForm, {
  onChange: setArgValue,
  opacity: getArgValue('opacity'),
  overflow: getArgValue('overflow'),
  padding: getArgValue('padding')
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxxs",
  textTransform: "uppercase"
}, /*#__PURE__*/_react.default.createElement("h6", null, strings.getBorderTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_border_form.BorderForm, {
  colors: workpad.colors,
  onChange: setArgValue,
  radius: getArgValue('borderRadius'),
  value: getArgValue('border')
}));
exports.ExtendedTemplate = ExtendedTemplate;
ExtendedTemplate.displayName = 'ContainerStyleArgExtendedInput';
ExtendedTemplate.propTypes = {
  getArgValue: _propTypes.default.func.isRequired,
  setArgValue: _propTypes.default.func.isRequired,
  // @ts-expect-error upgrade typescript v5.9.3
  workpad: _propTypes.default.shape({
    colors: _propTypes.default.array.isRequired
  }).isRequired
};