"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShapeComponent = exports.createShape = void 0;
exports.getShapeContentElement = getShapeContentElement;
exports.getViewBox = getViewBox;
exports.viewBoxToString = viewBoxToString;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function viewBoxToString(viewBox) {
  if (!viewBox) {
    return;
  }
  return `${viewBox === null || viewBox === void 0 ? void 0 : viewBox.minX} ${viewBox === null || viewBox === void 0 ? void 0 : viewBox.minY} ${viewBox === null || viewBox === void 0 ? void 0 : viewBox.width} ${viewBox === null || viewBox === void 0 ? void 0 : viewBox.height}`;
}
function getMinxAndWidth(viewBoxParams, {
  borderOffset,
  width
}) {
  let {
    minX,
    width: shapeWidth
  } = viewBoxParams;
  if (width) {
    const xOffset = shapeWidth / width * borderOffset;
    minX -= xOffset;
    shapeWidth += xOffset * 2;
  } else {
    shapeWidth = 0;
  }
  return [minX, shapeWidth];
}
function getMinyAndHeight(viewBoxParams, {
  borderOffset,
  height
}) {
  let {
    minY,
    height: shapeHeight
  } = viewBoxParams;
  if (height) {
    const yOffset = shapeHeight / height * borderOffset;
    minY -= yOffset;
    shapeHeight += yOffset * 2;
  } else {
    shapeHeight = 0;
  }
  return [minY, shapeHeight];
}
function getViewBox(viewBoxParams, parentNodeParams) {
  const [minX, width] = getMinxAndWidth(viewBoxParams, parentNodeParams);
  const [minY, height] = getMinyAndHeight(viewBoxParams, parentNodeParams);
  return {
    minX,
    minY,
    width,
    height
  };
}
const getShapeComponent = svgParams => function Shape({
  shapeAttributes,
  shapeContentAttributes,
  children,
  textAttributes
}) {
  const {
    viewBox: initialViewBox,
    shapeProps: defaultShapeContentAttributes,
    textAttributes: defaultTextAttributes,
    shapeType
  } = svgParams;
  const viewBox = shapeAttributes !== null && shapeAttributes !== void 0 && shapeAttributes.viewBox ? viewBoxToString(shapeAttributes === null || shapeAttributes === void 0 ? void 0 : shapeAttributes.viewBox) : viewBoxToString(initialViewBox);
  const SvgContentElement = getShapeContentElement(shapeType);
  const TextElement = textAttributes ? /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("text", (0, _extends2.default)({}, props, {
    ref: ref
  }))) : null;
  return /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
    xmlns: "http://www.w3.org/2000/svg"
  }, shapeAttributes || {}, {
    viewBox
  }), /*#__PURE__*/_react.default.createElement(SvgContentElement, (0, _extends2.default)({}, defaultShapeContentAttributes, shapeContentAttributes || {})), children, TextElement && /*#__PURE__*/_react.default.createElement(TextElement, (0, _extends2.default)({}, defaultTextAttributes || {}, textAttributes || {}), textAttributes === null || textAttributes === void 0 ? void 0 : textAttributes.textContent));
};
exports.getShapeComponent = getShapeComponent;
function getShapeContentElement(type) {
  switch (type) {
    case _types.SvgElementTypes.circle:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("circle", (0, _extends2.default)({}, props, {
        ref: ref
      })));
    case _types.SvgElementTypes.rect:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("rect", (0, _extends2.default)({}, props, {
        ref: ref
      })));
    case _types.SvgElementTypes.path:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("path", (0, _extends2.default)({}, props, {
        ref: ref
      })));
    default:
      return /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("polygon", (0, _extends2.default)({}, props, {
        ref: ref
      })));
  }
}
const createShape = props => {
  return {
    Component: getShapeComponent(props),
    data: props
  };
};
exports.createShape = createShape;