"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.forceReload = forceReload;
exports.useCanvasApi = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _embeddable_input_to_expression = require("../../../canvas_plugin_src/renderers/embeddable/embeddable_input_to_expression");
var _ui_metric = require("../../lib/ui_metric");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _lib = require("../../../common/lib");
var _kibana_services = require("../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error unconverted file

const reload$ = new _rxjs.Subject();
function forceReload() {
  reload$.next();
}
const useCanvasApi = () => {
  const selectedPageId = (0, _reactRedux.useSelector)(_workpad.getSelectedPage);
  const dispatch = (0, _reactRedux.useDispatch)();
  const createNewEmbeddable = (0, _react.useCallback)((type, embeddableInput) => {
    if (_ui_metric.trackCanvasUiMetric) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.CLICK, type);
    }
    if (embeddableInput) {
      const expression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(embeddableInput, type, undefined, true);
      dispatch((0, _elements.addElement)(selectedPageId, {
        expression
      }));
    }
  }, [selectedPageId, dispatch]);
  const getCanvasApi = (0, _react.useCallback)(() => {
    const panelStateMap = {};
    function getSerializedStateForChild(childId) {
      var _panelStateMap$childI, _panelStateMap$childI2;
      return (_panelStateMap$childI = (_panelStateMap$childI2 = panelStateMap[childId]) === null || _panelStateMap$childI2 === void 0 ? void 0 : _panelStateMap$childI2.value) !== null && _panelStateMap$childI !== void 0 ? _panelStateMap$childI : {
        rawState: {}
      };
    }
    return {
      getAppContext: () => ({
        getCurrentPath: () => {
          const urlToApp = _kibana_services.coreServices.application.getUrlForApp(_lib.CANVAS_APP);
          const inAppPath = window.location.pathname.replace(urlToApp, '');
          return inAppPath + window.location.search + window.location.hash;
        },
        currentAppId: _lib.CANVAS_APP
      }),
      reload$,
      viewMode$: new _rxjs.BehaviorSubject('edit'),
      // always in edit mode
      addNewPanel: async ({
        panelType,
        serializedState
      }) => {
        createNewEmbeddable(panelType, serializedState.rawState);
      },
      disableTriggers: true,
      // this is required to disable inline editing now enabled by default
      canEditInline: false,
      type: 'canvas',
      getSerializedStateForChild,
      lastSavedStateForChild$: childId => {
        var _panelStateMap$childI3;
        return (_panelStateMap$childI3 = panelStateMap[childId]) !== null && _panelStateMap$childI3 !== void 0 ? _panelStateMap$childI3 : (0, _rxjs.of)(undefined);
      },
      // Canvas auto saves so lastSavedState is the same as currentState
      getLastSavedStateForChild: getSerializedStateForChild,
      setSerializedStateForChild: (childId, serializePanelState) => {
        if (!panelStateMap[childId]) {
          panelStateMap[childId] = new _rxjs.BehaviorSubject(serializePanelState);
          return;
        }
        panelStateMap[childId].next(serializePanelState);
      }
    };
  }, [createNewEmbeddable]);
  return (0, _react.useMemo)(() => getCanvasApi(), [getCanvasApi]);
};
exports.useCanvasApi = useCanvasApi;