"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPickerPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _tinycolor = _interopRequireDefault(require("tinycolor2"));
var _popover = require("../popover");
var _color_dot = require("../color_dot");
var _color_picker = require("../color_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ColorPickerPopover = props => {
  const {
    value,
    anchorPosition,
    ariaLabel,
    ...rest
  } = props;
  const button = handleClick => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": `${ariaLabel} ${(0, _tinycolor.default)(value).toName() || value}`,
    style: {
      fontSize: 0
    },
    onClick: handleClick
  }, /*#__PURE__*/_react.default.createElement(_color_dot.ColorDot, {
    value: value
  }));
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    id: "color-picker-popover",
    panelClassName: "canvas canvasColorPickerPopover__popover",
    button: button,
    anchorPosition: anchorPosition
  }, () => /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, (0, _extends2.default)({
    value: value
  }, rest)));
};
exports.ColorPickerPopover = ColorPickerPopover;
ColorPickerPopover.propTypes = {
  ..._color_picker.ColorPicker.propTypes,
  // @ts-expect-error upgrade typescript v5.9.3
  anchorPosition: _propTypes.default.string
};