"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Error = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _show_debugging = require("./show_debugging");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getDescription: () => _i18n.i18n.translate('xpack.canvas.errorComponent.description', {
    defaultMessage: 'Expression failed with the message:'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.errorComponent.title', {
    defaultMessage: 'Whoops! Expression failed'
  })
};
const Error = ({
  payload,
  onClose
}) => {
  var _payload$error;
  const message = (_payload$error = payload.error) === null || _payload$error === void 0 ? void 0 : _payload$error.message;
  const CloseIconButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "cross",
    onClick: onClose,
    "aria-hidden": true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    css: {
      maxWidth: 500
    },
    color: "danger",
    iconType: CloseIconButton,
    title: strings.getTitle()
  }, /*#__PURE__*/_react.default.createElement("p", null, message ? strings.getDescription() : ''), message && /*#__PURE__*/_react.default.createElement("p", {
    style: {
      padding: '0 16px'
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    readOnly: true
  }, message)), /*#__PURE__*/_react.default.createElement(_show_debugging.ShowDebugging, {
    payload: payload
  }));
};
exports.Error = Error;