"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.image = void 0;
var _image = require("../../../i18n/functions/dict/image");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const image = () => {
  const {
    help,
    args: argHelp
  } = _image.help;
  return {
    name: 'image',
    aliases: [],
    type: 'image',
    inputTypes: ['null'],
    help,
    args: {
      dataurl: {
        // This was accepting dataurl, but there was no facility in fn for checking type and handling a dataurl type.
        types: ['string', 'null'],
        help: argHelp.dataurl,
        aliases: ['_', 'url'],
        default: null
      },
      mode: {
        types: ['string'],
        help: argHelp.mode,
        default: 'contain',
        options: Object.values(_image.ImageMode)
      }
    },
    fn: async (input, {
      dataurl,
      mode
    }) => {
      if (!mode || !Object.values(_image.ImageMode).includes(mode)) {
        throw new Error(_image.errors.invalidImageMode());
      }
      const {
        elasticLogo,
        resolveWithMissingImage
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../../public/lib')));
      const modeStyle = mode === 'stretch' ? '100% 100%' : mode;
      return {
        type: 'image',
        mode: modeStyle,
        dataurl: resolveWithMissingImage(dataurl, elasticLogo)
      };
    }
  };
};
exports.image = image;