"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmIndicesSavedObjectDefinition = exports.APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE = exports.APM_INDEX_SETTINGS_SAVED_OBJECT_ID = void 0;
exports.getApmIndicesSavedObject = getApmIndicesSavedObject;
exports.saveApmIndices = saveApmIndices;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/core/server");
var _update_apm_oss_index_paths = require("./migrations/update_apm_oss_index_paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE = exports.APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE = 'apm-indices';
const APM_INDEX_SETTINGS_SAVED_OBJECT_ID = exports.APM_INDEX_SETTINGS_SAVED_OBJECT_ID = 'apm-indices';
const apmIndicesSavedObjectDefinition = exports.apmIndicesSavedObjectDefinition = {
  name: APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE,
  hidden: false,
  namespaceType: 'single',
  mappings: {
    dynamic: false,
    properties: {} // several fields exist, but we don't need to search or aggregate on them, so we exclude them from the mappings
  },
  management: {
    importableAndExportable: true,
    icon: 'apmApp',
    getTitle: () => _i18n.i18n.translate('xpack.apmSourcesAccess.apmSettings.index', {
      defaultMessage: 'APM Settings - Index'
    })
  },
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        create: _configSchema.schema.object({
          apmIndices: _configSchema.schema.maybe(_configSchema.schema.object({
            error: _configSchema.schema.maybe(_configSchema.schema.string()),
            onboarding: _configSchema.schema.maybe(_configSchema.schema.string()),
            span: _configSchema.schema.maybe(_configSchema.schema.string()),
            transaction: _configSchema.schema.maybe(_configSchema.schema.string()),
            metric: _configSchema.schema.maybe(_configSchema.schema.string())
          })),
          isSpaceAware: _configSchema.schema.maybe(_configSchema.schema.boolean())
        })
      }
    }
  },
  migrations: {
    '7.16.0': doc => {
      const attributes = (0, _update_apm_oss_index_paths.updateApmOssIndexPaths)(doc.attributes);
      return {
        ...doc,
        attributes
      };
    },
    '8.2.0': doc => {
      // Any future changes on this structure should be also tested on migrateLegacyAPMIndicesToSpaceAware
      return {
        ...doc,
        attributes: {
          apmIndices: doc.attributes
        }
      };
    }
  }
};
function saveApmIndices(savedObjectsClient, apmIndices) {
  return savedObjectsClient.create(APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE, {
    apmIndices: removeEmpty(apmIndices),
    isSpaceAware: true
  }, {
    id: APM_INDEX_SETTINGS_SAVED_OBJECT_ID,
    overwrite: true
  });
}

// remove empty/undefined values
function removeEmpty(apmIndices) {
  return Object.entries(apmIndices).reduce((obj, [key, value]) => {
    var _value;
    value = (_value = value) === null || _value === void 0 ? void 0 : _value.trim();
    if (value) {
      obj[key] = value;
    }
    return obj;
  }, {});
}
async function getApmIndicesSavedObject(savedObjectsClient) {
  try {
    const apmIndicesSavedObject = await savedObjectsClient.get(APM_INDEX_SETTINGS_SAVED_OBJECT_TYPE, APM_INDEX_SETTINGS_SAVED_OBJECT_ID);
    return apmIndicesSavedObject.attributes.apmIndices;
  } catch (error) {
    // swallow error if saved object does not exist
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(error)) {
      return {};
    }
    throw error;
  }
}