"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventMetadata = getEventMetadata;
var _common = require("@kbn/observability-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEventMetadata({
  apmEventClient,
  processorEvent,
  id,
  start,
  end
}) {
  const fieldNames = getFieldNames(processorEvent);
  const response = await apmEventClient.search('get_event_metadata', {
    apm: {
      events: [processorEvent]
    },
    body: {
      track_total_hits: false,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), {
            bool: {
              should: fieldNames.flatMap(fieldName => (0, _server.termQuery)(fieldName, id)),
              minimum_should_match: 1
            }
          }]
        }
      },
      size: 1,
      _source: false,
      fields: [{
        field: '*',
        include_unmapped: true
      }]
    },
    terminate_after: 1
  });
  return response.hits.hits[0].fields;
}
function getFieldNames(processorEvent) {
  switch (processorEvent) {
    case _common.ProcessorEvent.error:
      return [_apm.ERROR_ID, _apm.ID];
    case _common.ProcessorEvent.transaction:
      return [_apm.TRANSACTION_ID];
    case _common.ProcessorEvent.span:
      return [_apm.SPAN_ID];
    default:
      throw new Error('Unknown processor event');
  }
}