"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedTransactionRate = getFailedTransactionRate;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _get_offset_in_ms = require("../../../common/utils/get_offset_in_ms");
var _transaction_error_rate = require("../helpers/transaction_error_rate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getFailedTransactionRate({
  environment,
  kuery,
  filters,
  serviceName,
  transactionTypes,
  transactionName,
  apmEventClient,
  start,
  end,
  offset,
  documentType,
  rollupInterval,
  bucketSizeInSeconds
}) {
  const {
    startWithOffset,
    endWithOffset
  } = (0, _get_offset_in_ms.getOffsetInMs)({
    start,
    end,
    offset
  });
  const filter = [{
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  }, {
    terms: {
      [_apm.TRANSACTION_TYPE]: transactionTypes
    }
  }, ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName), ...(0, _server.rangeQuery)(startWithOffset, endWithOffset), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...((filters === null || filters === void 0 ? void 0 : filters.filter) || [])];
  const mustNot = (filters === null || filters === void 0 ? void 0 : filters.must_not) || [];
  const outcomes = (0, _transaction_error_rate.getOutcomeAggregation)(documentType);
  const params = {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter,
          must_not: mustNot
        }
      },
      aggs: {
        ...outcomes,
        timeseries: {
          date_histogram: {
            field: '@timestamp',
            fixed_interval: `${bucketSizeInSeconds}s`,
            min_doc_count: 0,
            extended_bounds: {
              min: startWithOffset,
              max: endWithOffset
            }
          },
          aggs: {
            ...outcomes
          }
        }
      }
    }
  };
  const resp = await apmEventClient.search('get_transaction_group_error_rate', params);
  if (!resp.aggregations) {
    return {
      timeseries: [],
      average: null
    };
  }
  const timeseries = (0, _transaction_error_rate.getFailedTransactionRateTimeSeries)(resp.aggregations.timeseries.buckets);
  const average = (0, _transaction_error_rate.calculateFailedTransactionRate)(resp.aggregations);
  return {
    timeseries,
    average
  };
}