"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMLocatorPayloadValidator = void 0;
exports.getPathForServiceDetail = getPathForServiceDetail;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/Either");
var _PathReporter = require("io-ts/lib/PathReporter");
var _environment_rt = require("../../common/environment_rt");
var _apm_route_config = require("../components/routing/apm_route_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APMLocatorPayloadValidator = exports.APMLocatorPayloadValidator = t.union([t.type({
  serviceName: t.undefined
}), t.intersection([t.type({
  serviceName: t.string
}), t.type({
  dashboardId: t.string
}), t.type({
  query: _environment_rt.environmentRt
})]), t.intersection([t.type({
  serviceName: t.string
}), t.partial({
  dashboardId: t.undefined
}), t.partial({
  serviceOverviewTab: t.keyof({
    traces: null,
    metrics: null,
    logs: null,
    errors: null,
    transactions: null
  })
}), t.type({
  query: t.intersection([_environment_rt.environmentRt, t.partial({
    kuery: t.string,
    rangeFrom: t.string,
    rangeTo: t.string
  })])
})])]);
function getPathForServiceDetail(payload, {
  from,
  to,
  isComparisonEnabledByDefault,
  defaultEnvironment
}) {
  const decodedPayload = APMLocatorPayloadValidator.decode(payload);
  if (!(0, _Either.isRight)(decodedPayload)) {
    throw new Error(_PathReporter.PathReporter.report(decodedPayload).join('\n'));
  }
  const defaultQueryParams = {
    kuery: '',
    serviceGroup: '',
    comparisonEnabled: isComparisonEnabledByDefault,
    rangeFrom: from,
    rangeTo: to,
    environment: defaultEnvironment
  };
  if (!payload.serviceName) {
    return _apm_route_config.apmRouter.link('/services', {
      query: defaultQueryParams
    });
  }
  let path;
  if (payload.dashboardId !== undefined) {
    const apmPath = '/services/{serviceName}/dashboards';
    path = _apm_route_config.apmRouter.link(apmPath, {
      path: {
        serviceName: payload.serviceName
      },
      query: {
        ...defaultQueryParams,
        ...payload.query,
        dashboardId: payload.dashboardId
      }
    });
    return path;
  } else {
    const mapObj = {
      logs: '/services/{serviceName}/logs',
      metrics: '/services/{serviceName}/metrics',
      traces: '/services/{serviceName}/transactions',
      transactions: '/services/{serviceName}/transactions/view',
      errors: '/services/{serviceName}/errors',
      default: '/services/{serviceName}/overview'
    };
    const apmPath = mapObj[payload.serviceOverviewTab || 'default'];
    const query = {
      ...defaultQueryParams,
      ...payload.query
    };
    path = _apm_route_config.apmRouter.link(apmPath, {
      path: {
        serviceName: payload.serviceName
      },
      query
    });
  }
  return path;
}