"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreferredDataSourceAndBucketSize = usePreferredDataSourceAndBucketSize;
var _react = require("react");
var _common = require("@kbn/apm-data-access-plugin/common");
var _document_type = require("../../common/document_type");
var _get_bucket_size = require("../../common/utils/get_bucket_size");
var _use_time_range_metadata_context = require("../context/time_range_metadata/use_time_range_metadata_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the source and interval based on Time Range Metadata API
 *
 * @param {number} numBuckets - The number of buckets. Should be 20 for SparkPlots or 100 for Other charts.

 */

function usePreferredDataSourceAndBucketSize({
  start,
  end,
  kuery,
  numBuckets,
  type
}) {
  var _timeRangeMetadataFet;
  const timeRangeMetadataFetch = (0, _use_time_range_metadata_context.useTimeRangeMetadata)({
    start,
    end,
    kuery
  });
  const sources = (_timeRangeMetadataFet = timeRangeMetadataFetch.data) === null || _timeRangeMetadataFet === void 0 ? void 0 : _timeRangeMetadataFet.sources;
  return (0, _react.useMemo)(() => {
    if (!sources) {
      return null;
    }
    let suitableTypes;
    if (type === _document_type.ApmDocumentType.ServiceTransactionMetric) {
      suitableTypes = [_document_type.ApmDocumentType.ServiceTransactionMetric, _document_type.ApmDocumentType.TransactionMetric, _document_type.ApmDocumentType.TransactionEvent];
    } else if (type === _document_type.ApmDocumentType.TransactionMetric) {
      suitableTypes = [_document_type.ApmDocumentType.TransactionMetric, _document_type.ApmDocumentType.TransactionEvent];
    }
    const {
      bucketSizeInSeconds,
      source
    } = (0, _common.getPreferredBucketSizeAndDataSource)({
      bucketSizeInSeconds: (0, _get_bucket_size.getBucketSize)({
        numBuckets,
        start: new Date(start).getTime(),
        end: new Date(end).getTime()
      }).bucketSize,
      sources: sources.filter(s => suitableTypes.includes(s.documentType))
    });
    return {
      bucketSizeInSeconds,
      source: source
    };
  }, [type, start, end, sources, numBuckets]);
}