"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmEmbeddableContext = ApmEmbeddableContext;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _apm_plugin_context = require("../context/apm_plugin/apm_plugin_context");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
var _app_root = require("../components/routing/app_root");
var _chart_pointer_event_context = require("../context/chart_pointer_event/chart_pointer_event_context");
var _time_range_metadata_context = require("../context/time_range_metadata/time_range_metadata_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmEmbeddableContext({
  rangeFrom = 'now-15m',
  rangeTo = 'now',
  kuery = '',
  deps,
  children
}) {
  const services = {
    config: deps.config,
    core: deps.coreStart,
    plugins: deps.pluginsSetup,
    data: deps.pluginsStart.data,
    inspector: deps.pluginsStart.inspector,
    observability: deps.pluginsStart.observability,
    observabilityShared: deps.pluginsStart.observabilityShared,
    dataViews: deps.pluginsStart.dataViews,
    unifiedSearch: deps.pluginsStart.unifiedSearch,
    lens: deps.pluginsStart.lens,
    uiActions: deps.pluginsStart.uiActions,
    observabilityAIAssistant: deps.pluginsStart.observabilityAIAssistant,
    share: deps.pluginsSetup.share,
    kibanaEnvironment: deps.kibanaEnvironment,
    observabilityRuleTypeRegistry: deps.observabilityRuleTypeRegistry
  };
  (0, _create_call_apm_api.createCallApmApi)(deps.coreStart);
  const I18nContext = deps.coreStart.i18n.Context;
  return /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_apm_plugin_context.ApmPluginContext.Provider, {
    value: services
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: deps.coreStart.theme
  }, /*#__PURE__*/_react.default.createElement(_app_root.ApmThemeProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: deps.coreStart
  }, /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.TimeRangeMetadataContextProvider, {
    uiSettings: deps.coreStart.uiSettings,
    start: rangeFrom,
    end: rangeTo,
    kuery: kuery,
    useSpanName: false
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, children)))))));
}