"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfall = TraceWaterfall;
exports.convertTreeToList = convertTreeToList;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactVirtualized = require("react-virtualized");
var _reactWindow = require("react-window");
var _timeline = require("../charts/timeline");
var _trace_item_row = require("./trace_item_row");
var _trace_waterfall_context = require("./trace_waterfall_context");
var _trace_warning = require("./trace_warning");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceWaterfall({
  traceItems,
  showAccordion = true,
  highlightedTraceId,
  onClick,
  onErrorClick,
  scrollElement,
  getRelatedErrorsHref,
  isEmbeddable = false
}) {
  return /*#__PURE__*/_react2.default.createElement(_trace_waterfall_context.TraceWaterfallContextProvider, {
    traceItems: traceItems,
    showAccordion: showAccordion,
    highlightedTraceId: highlightedTraceId,
    onClick: onClick,
    onErrorClick: onErrorClick,
    scrollElement: scrollElement,
    getRelatedErrorsHref: getRelatedErrorsHref,
    isEmbeddable: isEmbeddable
  }, /*#__PURE__*/_react2.default.createElement(_trace_warning.TraceWarning, null, /*#__PURE__*/_react2.default.createElement(TraceWaterfallComponent, null)));
}
function TraceWaterfallComponent() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    duration,
    margin: {
      left,
      right
    },
    isEmbeddable
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  return /*#__PURE__*/_react2.default.createElement("div", {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          display: flex;
          position: sticky;
          top: ${isEmbeddable ? '0px' : 'var(--euiFixedHeadersOffset, 0)'};
          z-index: ${euiTheme.levels.menu};
          background-color: ${euiTheme.colors.emptyShade};
          border-bottom: ${euiTheme.border.thin};
        `
  }, /*#__PURE__*/_react2.default.createElement(_timeline.TimelineAxisContainer, {
    xMax: duration,
    margins: {
      top: 40,
      left,
      right,
      bottom: 0
    },
    numberOfTicks: 3
  })), /*#__PURE__*/_react2.default.createElement(_timeline.VerticalLinesContainer, {
    xMax: duration,
    margins: {
      top: 40,
      left,
      right,
      bottom: 0
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          position: relative;
        `
  }, /*#__PURE__*/_react2.default.createElement(TraceTree, null)));
}
function TraceTree() {
  const {
    traceWaterfallMap,
    traceWaterfall,
    scrollElement
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  const listRef = (0, _react2.useRef)(null);
  const rowSizeMapRef = (0, _react2.useRef)(new Map());
  const [accordionStatesMap, setAccordionStateMap] = (0, _react2.useState)(traceWaterfall.reduce((acc, item) => {
    acc[item.id] = 'open';
    return acc;
  }, {}));
  function toggleAccordionState(id) {
    setAccordionStateMap(prevStates => ({
      ...prevStates,
      [id]: prevStates[id] === 'open' ? 'closed' : 'open'
    }));
  }
  const onRowLoad = (index, size) => {
    rowSizeMapRef.current.set(index, size);
  };
  const getRowSize = index => {
    return rowSizeMapRef.current.get(index) || _trace_item_row.ACCORDION_HEIGHT + _trace_item_row.BORDER_THICKNESS;
  };
  const onScroll = ({
    scrollTop
  }) => {
    var _listRef$current;
    (_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.scrollTo(scrollTop);
  };
  const visibleList = (0, _react2.useMemo)(() => convertTreeToList(traceWaterfallMap, accordionStatesMap, traceWaterfall[0]), [accordionStatesMap, traceWaterfall, traceWaterfallMap]);
  return /*#__PURE__*/_react2.default.createElement(_reactVirtualized.WindowScroller, {
    onScroll: onScroll,
    scrollElement: scrollElement
  }, ({
    registerChild
  }) => /*#__PURE__*/_react2.default.createElement(_reactVirtualized.AutoSizer, {
    disableHeight: true
  }, ({
    width
  }) =>
  /*#__PURE__*/
  // @ts-expect-error @types/react@18 Type 'HTMLDivElement' is not assignable to type 'ReactNode'
  _react2.default.createElement("div", {
    "data-test-subj": "waterfall",
    ref: registerChild
  }, /*#__PURE__*/_react2.default.createElement(_reactWindow.VariableSizeList, {
    ref: listRef,
    style: {
      height: '100%'
    },
    itemCount: visibleList.length,
    itemSize: getRowSize,
    height: window.innerHeight,
    width: width,
    itemData: {
      traceList: visibleList,
      onLoad: onRowLoad,
      traceWaterfallMap,
      accordionStatesMap,
      toggleAccordionState
    }
  }, VirtualRow))));
}
const VirtualRow = /*#__PURE__*/_react2.default.memo(({
  index,
  style,
  data
}) => {
  const {
    onLoad,
    traceList,
    accordionStatesMap,
    toggleAccordionState,
    traceWaterfallMap
  } = data;
  const ref = _react2.default.useRef(null);
  (0, _react2.useEffect)(() => {
    var _ref$current$getBound, _ref$current;
    onLoad(index, (_ref$current$getBound = (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.getBoundingClientRect().height) !== null && _ref$current$getBound !== void 0 ? _ref$current$getBound : _trace_item_row.ACCORDION_HEIGHT);
  }, [index, onLoad]);
  const item = traceList[index];
  const children = traceWaterfallMap[item.id] || [];
  return /*#__PURE__*/_react2.default.createElement("div", {
    style: style,
    ref: ref
  }, /*#__PURE__*/_react2.default.createElement(_trace_item_row.TraceItemRow, {
    key: item.id,
    item: item,
    childrenCount: children.length,
    state: accordionStatesMap[item.id] || 'open',
    onToggle: toggleAccordionState
  }));
}, _reactWindow.areEqual);
function convertTreeToList(treeMap, accordionsState, root) {
  if (!root) {
    return [];
  }
  const result = [];
  const stack = [root];
  while (stack.length > 0) {
    const current = stack.pop();
    if (current) {
      const children = treeMap[current.id] || [];
      result.push(current);
      const state = accordionsState[current.id] || 'open';
      if (state === 'open') {
        for (let i = children.length - 1; i >= 0; i--) {
          stack.push(children[i]);
        }
      }
    }
  }
  return result;
}