"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildLogsExplorerLocatorConfig = void 0;
var _routerUtils = require("@kbn/router-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildLogsExplorerLocatorConfig = ({
  locator,
  kuery,
  from,
  to
}) => {
  const params = {
    timeRange: {
      from,
      to
    },
    ...(kuery && {
      query: {
        language: 'kuery',
        query: kuery
      }
    })
  };
  const urlToLogsExplorer = locator.getRedirectUrl(params);
  const navigateToLogsExplorer = () => {
    locator.navigate(params);
  };
  const logsExplorerLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: urlToLogsExplorer,
    onClick: navigateToLogsExplorer
  });
  return {
    logsExplorerLinkProps
  };
};
exports.buildLogsExplorerLocatorConfig = buildLogsExplorerLocatorConfig;