"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartMetricType = void 0;
exports.getMetricsFormula = getMetricsFormula;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChartMetricType = exports.ChartMetricType = /*#__PURE__*/function (ChartMetricType) {
  ChartMetricType[ChartMetricType["LOG_ERROR_RATE"] = 0] = "LOG_ERROR_RATE";
  ChartMetricType[ChartMetricType["LOG_RATE"] = 1] = "LOG_RATE";
  return ChartMetricType;
}({});
const metricsFormulasMap = {
  [ChartMetricType.LOG_RATE]: `count() / [PERIOD_IN_MINUTES]`,
  [ChartMetricType.LOG_ERROR_RATE]: `count(kql='log.level: "error" OR log.level: "ERROR" OR error.log.level: "error" OR error.log.level: "ERROR"') / [PERIOD_IN_MINUTES]`
};
function getMetricsFormula(chartMetricType) {
  return metricsFormulasMap[chartMetricType];
}