"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmAppRoot = ApmAppRoot;
exports.ApmThemeProvider = ApmThemeProvider;
var _ebtTools = require("@kbn/ebt-tools");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _public4 = require("@kbn/observability-shared-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = require("styled-components");
var _eui = require("@elastic/eui");
var _kibana_environment_context = require("../../../context/kibana_environment_context/kibana_environment_context");
var _anomaly_detection_jobs_context = require("../../../context/anomaly_detection_jobs/anomaly_detection_jobs_context");
var _apm_plugin_context = require("../../../context/apm_plugin/apm_plugin_context");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _context = require("../../../context/breadcrumbs/context");
var _license_context = require("../../../context/license/license_context");
var _time_range_id_context = require("../../../context/time_range_id/time_range_id_context");
var _url_params_context = require("../../../context/url_params_context/url_params_context");
var _apm_error_boundary = require("../apm_error_boundary");
var _apm_route_config = require("../apm_route_config");
var _track_pageview = require("../track_pageview");
var _apm_header_action_menu = require("./apm_header_action_menu");
var _redirect_dependencies_to_dependencies_inventory = require("./redirect_dependencies_to_dependencies_inventory");
var _redirect_with_default_date_range = require("./redirect_with_default_date_range");
var _redirect_with_default_environment = require("./redirect_with_default_environment");
var _redirect_with_offset = require("./redirect_with_offset");
var _scroll_to_top_on_path_change = require("./scroll_to_top_on_path_change");
var _update_execution_context_on_route_change = require("./update_execution_context_on_route_change");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storage = new _public3.Storage(localStorage);
function ApmAppRoot({
  apmPluginContextValue,
  pluginsStart,
  apmServices
}) {
  const {
    appMountParameters,
    kibanaEnvironment,
    core
  } = apmPluginContextValue;
  const {
    history
  } = appMountParameters;
  const i18nCore = core.i18n;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "apmMainContainer",
    role: "main"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_plugin_context.ApmPluginContext.Provider, {
    value: apmPluginContextValue
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...pluginsStart,
      storage,
      ...apmServices
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_environment_context.KibanaEnvironmentContextProvider, {
    kibanaEnvironment: kibanaEnvironment
  }, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_time_range_id_context.TimeRangeIdContextProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _apm_route_config.apmRouter
  }, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, null, /*#__PURE__*/_react.default.createElement(_apm_error_boundary.ApmErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_redirect_dependencies_to_dependencies_inventory.RedirectDependenciesToDependenciesInventory, null, /*#__PURE__*/_react.default.createElement(_redirect_with_default_environment.RedirectWithDefaultEnvironment, null, /*#__PURE__*/_react.default.createElement(_redirect_with_default_date_range.RedirectWithDefaultDateRange, null, /*#__PURE__*/_react.default.createElement(_redirect_with_offset.RedirectWithOffset, null, /*#__PURE__*/_react.default.createElement(_track_pageview.TrackPageview, null, /*#__PURE__*/_react.default.createElement(_update_execution_context_on_route_change.UpdateExecutionContextOnRouteChange, null, /*#__PURE__*/_react.default.createElement(_context.BreadcrumbsContextProvider, null, /*#__PURE__*/_react.default.createElement(_url_params_context.UrlParamsProvider, null, /*#__PURE__*/_react.default.createElement(_license_context.LicenseProvider, null, /*#__PURE__*/_react.default.createElement(_anomaly_detection_jobs_context.AnomalyDetectionJobsContextProvider, null, /*#__PURE__*/_react.default.createElement(_public4.InspectorContextProvider, null, /*#__PURE__*/_react.default.createElement(ApmThemeProvider, null, /*#__PURE__*/_react.default.createElement(MountApmHeaderActionMenu, null), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _scroll_to_top_on_path_change.ScrollToTopOnPathChange
  }), /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, null)))))))))))))))))))))));
}
function MountApmHeaderActionMenu() {
  const {
    appMountParameters: {
      setHeaderActionMenu,
      theme$
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return /*#__PURE__*/_react.default.createElement(_public4.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_apm_header_action_menu.ApmHeaderActionMenu, null))));
}
function ApmThemeProvider({
  children
}) {
  const darkMode = (0, _public2.useDarkMode)(false);
  return /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: outerTheme => ({
      ...outerTheme,
      eui: darkMode ? _uiTheme.euiDarkVars : _uiTheme.euiLightVars,
      darkMode
    })
  }, children);
}