"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderMustache = renderMustache;
var _mustache = _interopRequireDefault(require("mustache"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEMPLATE_TAGS = ['{', '}'];
function renderMustache({
  text,
  docLinks
}) {
  const template = Array.isArray(text) ? text.join('\n') : text;
  _mustache.default.parse(template, TEMPLATE_TAGS);
  return _mustache.default.render(template, {
    config: {
      docs: {
        base_url: docLinks === null || docLinks === void 0 ? void 0 : docLinks.ELASTIC_WEBSITE_URL,
        version: docLinks === null || docLinks === void 0 ? void 0 : docLinks.DOC_LINK_VERSION
      }
    }
  });
}