"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentInstances = AgentInstances;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _use_progressive_fetcher = require("../../../../../hooks/use_progressive_fetcher");
var _use_time_range = require("../../../../../hooks/use_time_range");
var _responsive_flyout = require("../../../transaction_details/waterfall_with_summary/waterfall_container/waterfall/responsive_flyout");
var _agent_contextual_information = require("./agent_contextual_information");
var _agent_instances_details = require("./agent_instances_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAgentInstancesFetcher({
  serviceName,
  environment,
  kuery,
  start,
  end
}) {
  return (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/agent_instances', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          start,
          end,
          kuery
        }
      }
    });
  }, [start, end, serviceName, environment, kuery]);
}
function AgentInstances({
  agent,
  isLatestVersionsLoading,
  latestVersionsFailed,
  onClose
}) {
  var _instances$data$items, _instances$data;
  const {
    query,
    query: {
      environment,
      kuery
    }
  } = (0, _use_apm_params.useApmParams)('/settings/agent-explorer');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom: 'now-24h',
    rangeTo: 'now'
  });
  const instances = useAgentInstancesFetcher({
    environment,
    kuery,
    start,
    end,
    serviceName: agent.serviceName
  });
  const isLoading = instances.status === _use_fetcher.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_responsive_flyout.ResponsiveFlyout, {
    onClose: onClose,
    ownFocus: true,
    maxWidth: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.apm.agentExplorer.instancesFlyout.title', {
    defaultMessage: 'Agent Instances'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_agent_contextual_information.AgentContextualInformation, {
    agentName: agent.agentName,
    serviceName: agent.serviceName,
    agentDocsPageUrl: agent.agentDocsPageUrl,
    instances: agent.instances,
    latestVersion: agent.latestVersion,
    query: query,
    isLatestVersionsLoading: isLatestVersionsLoading,
    latestVersionsFailed: latestVersionsFailed
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_agent_instances_details.AgentInstancesDetails, {
    serviceName: agent.serviceName,
    environment: environment,
    agentName: agent.agentName,
    start: start,
    end: end,
    agentDocsPageUrl: agent.agentDocsPageUrl,
    isLoading: isLoading,
    items: (_instances$data$items = (_instances$data = instances.data) === null || _instances$data === void 0 ? void 0 : _instances$data.items) !== null && _instances$data$items !== void 0 ? _instances$data$items : []
  }))));
}