"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.identifier = identifier;
exports.string = string;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function string(parts, ...variables) {
  const joined = Array.from(parts.raw).concat(variables.map(String)).join('');
  return `"${joined.replaceAll(/[^\\]"/g, '\\"')}"`;
}
function identifier(parts, ...variables) {
  const joined = Array.from(parts.raw).concat(variables.map(String)).join('');
  const escaped = `\`${joined.replaceAll(/[^\\]`/g, '\\`')}\``;
  return escaped;
}