"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentTypeConfig = getDocumentTypeConfig;
var _common = require("../../../common");
var _get_preferred_bucket_size_and_data_source = require("../../../common/utils/get_preferred_bucket_size_and_data_source");
var _document_type = require("../../lib/helpers/create_es_client/document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDocumentTypeConfig({
  start,
  end,
  numBuckets,
  documentTypes,
  documentSources
}) {
  const preferredSource = (0, _get_preferred_bucket_size_and_data_source.getPreferredBucketSizeAndDataSource)({
    sources: documentSources.filter(s => documentTypes.includes(s.documentType)),
    bucketSizeInSeconds: (0, _common.getBucketSize)({
      start,
      end,
      numBuckets
    }).bucketSize
  });
  const documentTypeConfig = (0, _document_type.getConfigForDocumentType)(preferredSource.source.documentType);
  return {
    preferredSource,
    documentTypeConfig
  };
}