"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partiallyUpdateAdHocRun = partiallyUpdateAdHocRun;
var _server = require("@kbn/core/server");
var _lodash = require("lodash");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// typed this way so we can send a SavedObjectClient or SavedObjectRepository

async function partiallyUpdateAdHocRun(savedObjectsClient, id, attributes, options = {}) {
  // ensure we only have the valid attributes that are not encrypted and are excluded from AAD
  const attributeUpdates = (0, _lodash.omit)(attributes, [..._saved_objects.AdHocRunAttributesToEncrypt, ..._saved_objects.AdHocRunAttributesIncludedInAAD]);
  const updateOptions = (0, _lodash.pick)(options, 'namespace', 'version', 'refresh');
  try {
    await savedObjectsClient.update(_saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE, id, attributeUpdates, updateOptions);
  } catch (err) {
    if (options !== null && options !== void 0 && options.ignore404 && _server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      return;
    }
    throw err;
  }
}