"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdHocTaskRunningHandler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../common/constants");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIME_TO_WAIT = 2000;
class AdHocTaskRunningHandler {
  constructor(client, logger) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "runningTimeoutId", void 0);
    (0, _defineProperty2.default)(this, "runningPromise", void 0);
    this.client = client;
    this.logger = logger;
  }
  start(adHocRunParamsId, schedule, namespace) {
    this.runningTimeoutId = setTimeout(() => {
      this.setRunning(adHocRunParamsId, schedule, namespace);
    }, TIME_TO_WAIT);
  }
  stop() {
    if (this.runningTimeoutId) {
      clearTimeout(this.runningTimeoutId);
    }
  }
  async waitFor() {
    this.stop();
    if (this.runningPromise) return this.runningPromise;else return Promise.resolve();
  }
  setRunning(adHocRunParamsId, schedule, namespace) {
    this.runningPromise = (0, _lib.partiallyUpdateAdHocRun)(this.client, adHocRunParamsId, {
      status: _constants.adHocRunStatus.RUNNING,
      schedule
    }, {
      ignore404: true,
      namespace,
      refresh: false
    });
    this.runningPromise.then(() => {
      this.runningPromise = undefined;
    }).catch(err => {
      this.runningPromise = undefined;
      this.logger.error(`error updating status and schedule attribute for ad hoc run ${adHocRunParamsId} ${err.message}`);
    });
  }
}
exports.AdHocTaskRunningHandler = AdHocTaskRunningHandler;