"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawRuleSchema = exports.rawRuleInvestigationGuideSchema = exports.artifactsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("./v5");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rawRuleInvestigationGuideSchema = exports.rawRuleInvestigationGuideSchema = _configSchema.schema.object({
  blob: _configSchema.schema.string()
});
const artifactsSchema = exports.artifactsSchema = _v.artifactsSchema.extends({
  investigation_guide: _configSchema.schema.maybe(rawRuleInvestigationGuideSchema)
});
const rawRuleSchema = exports.rawRuleSchema = _v.rawRuleSchema.extends({
  artifacts: _configSchema.schema.maybe(artifactsSchema)
});