"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractReferences = extractReferences;
var _constants = require("../common/constants");
var _denormalize_actions = require("./denormalize_actions");
var _denormalize_artifacts = require("./denormalize_artifacts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function extractReferences(context, ruleType, ruleActions, ruleParams, ruleArtifacts) {
  var _ruleType$useSavedObj, _extractedRefsAndPara, _ref;
  const actionsClient = await context.getActionsClient();
  const {
    references: actionReferences,
    actions
  } = await (0, _denormalize_actions.denormalizeActions)(actionsClient, ruleActions);
  const {
    artifacts,
    references: artifactReferences
  } = (0, _denormalize_artifacts.denormalizeArtifacts)(ruleArtifacts);

  // Extracts any references using configured reference extractor if available
  const extractedRefsAndParams = ruleType !== null && ruleType !== void 0 && (_ruleType$useSavedObj = ruleType.useSavedObjectReferences) !== null && _ruleType$useSavedObj !== void 0 && _ruleType$useSavedObj.extractReferences ? ruleType.useSavedObjectReferences.extractReferences(ruleParams) : null;
  const extractedReferences = (_extractedRefsAndPara = extractedRefsAndParams === null || extractedRefsAndParams === void 0 ? void 0 : extractedRefsAndParams.references) !== null && _extractedRefsAndPara !== void 0 ? _extractedRefsAndPara : [];
  const params = (_ref = extractedRefsAndParams === null || extractedRefsAndParams === void 0 ? void 0 : extractedRefsAndParams.params) !== null && _ref !== void 0 ? _ref : ruleParams;

  // Prefix extracted references in order to avoid clashes with framework level references
  const paramReferences = extractedReferences.map(reference => ({
    ...reference,
    name: `${_constants.extractedSavedObjectParamReferenceNamePrefix}${reference.name}`
  }));
  const references = [...actionReferences, ...paramReferences, ...artifactReferences];
  return {
    actions,
    artifacts,
    params,
    references
  };
}