"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteBackfillRoute = void 0;
var _delete = require("../../../../../common/routes/backfill/apis/delete");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteBackfillRoute = (router, licenseState) => {
  router.delete({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/backfill/{id}`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _delete.deleteParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    await rulesClient.deleteBackfill(params.id);
    return res.noContent();
  })));
};
exports.deleteBackfillRoute = deleteBackfillRoute;