"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRequestToAlertDeletePreview = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRequestToAlertDeletePreview = ({
  active_alert_delete_threshold: activeAlertDeleteThreshold,
  inactive_alert_delete_threshold: inactiveAlertDeleteThreshold,
  category_ids: _categoryIds
}) => {
  // Accepting single category id or array of category ids because
  // sending an array of just one element in decoded as a simple string
  const getCategoryIds = input => {
    return Array.isArray(input) ? input : [input];
  };
  const isActiveAlertDeleteEnabled = Boolean(activeAlertDeleteThreshold);
  const isInactiveAlertDeleteEnabled = Boolean(inactiveAlertDeleteThreshold);
  return {
    isActiveAlertDeleteEnabled,
    isInactiveAlertDeleteEnabled,
    activeAlertDeleteThreshold: activeAlertDeleteThreshold !== null && activeAlertDeleteThreshold !== void 0 ? activeAlertDeleteThreshold : 1,
    inactiveAlertDeleteThreshold: inactiveAlertDeleteThreshold !== null && inactiveAlertDeleteThreshold !== void 0 ? inactiveAlertDeleteThreshold : 1,
    categoryIds: getCategoryIds(_categoryIds)
  };
};
exports.transformRequestToAlertDeletePreview = transformRequestToAlertDeletePreview;