"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findGapsById = void 0;
var _saved_objects = require("../../saved_objects");
var _transform_to_gap = require("./transforms/transform_to_gap");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findGapsById = async ({
  eventLogClient,
  logger,
  params
}) => {
  const {
    gapIds,
    ruleId,
    page,
    perPage
  } = params;
  try {
    const filter = gapIds.map(id => `_id: ${id}`).join(' OR ');
    const gapsResponse = await eventLogClient.findEventsBySavedObjectIds(_saved_objects.RULE_SAVED_OBJECT_TYPE, [ruleId], {
      filter,
      page,
      per_page: perPage
    });
    if (gapsResponse.total === 0) return [];
    const gaps = (0, _transform_to_gap.transformToGap)(gapsResponse);
    return gaps;
  } catch (err) {
    logger.error(`Failed to find gaps by id ${gapIds.join(',')} for rule ${ruleId.toString()}: ${err.message}`);
    throw err;
  }
};
exports.findGapsById = findGapsById;