"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.determineFlappingAlerts = determineFlappingAlerts;
var _set_flapping = require("./set_flapping");
var _set_flapping_history_and_tracked_alerts = require("./set_flapping_history_and_tracked_alerts");
var _delay_recovered_flapping_alerts = require("./delay_recovered_flapping_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function determineFlappingAlerts({
  newAlerts,
  activeAlerts,
  recoveredAlerts,
  flappingSettings,
  previouslyRecoveredAlerts,
  actionGroupId
}) {
  (0, _set_flapping.setFlapping)(flappingSettings, activeAlerts, recoveredAlerts);
  let alerts = (0, _set_flapping_history_and_tracked_alerts.setFlappingHistoryAndTrackedAlerts)(flappingSettings, newAlerts, activeAlerts, recoveredAlerts, previouslyRecoveredAlerts);
  alerts = (0, _delay_recovered_flapping_alerts.delayRecoveredFlappingAlerts)(flappingSettings, actionGroupId, alerts.newAlerts, alerts.activeAlerts, alerts.trackedActiveAlerts, alerts.recoveredAlerts, alerts.trackedRecoveredAlerts);
  return alerts;
}