"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToSanitizedRule = transformToSanitizedRule;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lib = require("../../../../rules_client/lib");
var _schemas = require("../../schemas");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function transformToSanitizedRule(context, ruleSo, options) {
  const {
    includeLegacyId = false,
    includeSnoozeData = false,
    excludeFromPublicApi = false
  } = options;
  const ruleType = context.ruleTypeRegistry.get(ruleSo.attributes.alertTypeId);
  const ruleDomain = (0, _transforms.transformRuleAttributesToRuleDomain)(ruleSo.attributes, {
    id: ruleSo.id,
    logger: context.logger,
    ruleType,
    references: ruleSo.references,
    includeSnoozeData
  }, context.isSystemAction);

  // Try to validate created rule, but don't throw.
  try {
    _schemas.ruleDomainSchema.validate(ruleDomain);
  } catch (e) {
    context.logger.warn(`Error validating get rule domain object for id: ${ruleSo.id}, ${e}`);
  }

  // Convert domain rule to rule (Remove certain properties)
  const rule = (0, _transforms.transformRuleDomainToRule)(ruleDomain, {
    isPublic: excludeFromPublicApi,
    includeLegacyId
  });

  // format legacy actions for SIEM rules
  if (ruleSo.attributes.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
    const [migratedRule] = await (0, _lib.formatLegacyActions)([rule], {
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      logger: context.logger
    });
    return migratedRule;
  }

  // TODO (http-versioning): Remove this cast, this enables us to move forward
  // without fixing all of other solution types
  return rule;
}