"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexTemplateAndPattern = exports.getComponentTemplateName = exports.getComponentTemplate = exports.VALID_ALERT_INDEX_PREFIXES = void 0;
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VALID_ALERT_INDEX_PREFIXES = exports.VALID_ALERT_INDEX_PREFIXES = ['.ds-.alerts-', '.alerts-', '.internal.alerts-', '.reindexed-v8-internal.alerts-', '.preview.alerts-', '.internal.preview.alerts-', '.reindexed-v8-internal.preview.alerts-', '.adhoc.alerts-', '.internal.adhoc.alerts-'];
const getComponentTemplateName = ({
  context,
  name
} = {}) => `.alerts-${context ? `${context}.alerts` : name ? name : 'framework'}-mappings`;
exports.getComponentTemplateName = getComponentTemplateName;
const getIndexTemplateAndPattern = ({
  context,
  namespace,
  secondaryAlias
}) => {
  const concreteNamespace = namespace ? namespace : 'default';
  const pattern = `${context}.alerts`;
  const patternWithNamespace = `${pattern}-${concreteNamespace}`;
  return {
    template: `.alerts-${patternWithNamespace}-index-template`,
    pattern: `.internal.alerts-${patternWithNamespace}-*`,
    reindexedPattern: `.reindexed-v8-internal.alerts-${patternWithNamespace}-*`,
    basePattern: `.alerts-${pattern}-*`,
    name: `.internal.alerts-${patternWithNamespace}-000001`,
    alias: `.alerts-${patternWithNamespace}`,
    validPrefixes: VALID_ALERT_INDEX_PREFIXES,
    ...(secondaryAlias ? {
      secondaryAlias: `${secondaryAlias}-${concreteNamespace}`
    } : {})
  };
};
exports.getIndexTemplateAndPattern = getIndexTemplateAndPattern;
const getComponentTemplate = ({
  fieldMap,
  context,
  name,
  dynamic,
  includeSettings,
  dynamicTemplates
}) => (0, _common.getComponentTemplateFromFieldMap)({
  name: getComponentTemplateName({
    context,
    name
  }),
  fieldMap,
  dynamic,
  includeSettings,
  dynamicTemplates
});
exports.getComponentTemplate = getComponentTemplate;