"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.previewTask = void 0;
var _alert_deletion_client = require("../alert_deletion_client");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const previewTask = async (context, settings, spaceId) => {
  const esClient = await context.elasticsearchClientPromise;
  const {
    isActiveAlertDeleteEnabled,
    isInactiveAlertDeleteEnabled,
    activeAlertDeleteThreshold,
    inactiveAlertDeleteThreshold,
    categoryIds
  } = settings;
  if (categoryIds && categoryIds.length > 0) {
    if (categoryIds.some(category => !_alert_deletion_client.allowedAppCategories.includes(category))) {
      throw new Error(`Invalid category id - ${categoryIds}`);
    }
  }
  const ruleTypes = context.ruleTypeRegistry.getAllTypesForCategories(categoryIds);
  const indices = context.getAlertIndicesAlias(ruleTypes, spaceId);
  let numAlertsToBeDeleted = 0;
  if (isActiveAlertDeleteEnabled) {
    const activeAlertsQuery = (0, _.getActiveAlertsQuery)(activeAlertDeleteThreshold, spaceId);
    try {
      const countResponse = await esClient.count({
        index: indices,
        query: activeAlertsQuery,
        allow_no_indices: true,
        ignore_unavailable: true
      });
      numAlertsToBeDeleted += countResponse.count;
    } catch (err) {
      context.logger.error(`Error determining the number of active alerts to delete: ${err.message}`);
      throw err;
    }
  }
  if (isInactiveAlertDeleteEnabled) {
    const inactiveAlertsQuery = (0, _.getInactiveAlertsQuery)(inactiveAlertDeleteThreshold, spaceId);
    try {
      const countResponse = await esClient.count({
        index: indices,
        query: inactiveAlertsQuery,
        allow_no_indices: true,
        ignore_unavailable: true
      });
      numAlertsToBeDeleted += countResponse.count;
    } catch (err) {
      context.logger.error(`Error determining the number of inactive alerts to delete: ${err.message}`);
      throw err;
    }
  }
  return numAlertsToBeDeleted;
};
exports.previewTask = previewTask;