"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _recurring_schedule_form_schema = require("@kbn/response-ops-recurring-schedule-form/schemas/recurring_schedule_form_schema");
var i18n = _interopRequireWildcard(require("../translations"));
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const schema = exports.schema = {
  title: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    label: i18n.NAME,
    validations: [{
      validator: emptyField(i18n.CREATE_FORM_NAME_REQUIRED)
    }]
  },
  solutionId: {
    type: _hook_form_lib.FIELD_TYPES.SELECT,
    validations: [{
      validator: ({
        value
      }) => {
        if (value === undefined) {
          return;
        }
        if (!_constants.VALID_CATEGORIES.includes(value)) {
          return {
            message: `Value must be one of: ${_constants.VALID_CATEGORIES.join(', ')}`
          };
        }
      }
    }],
    // The empty string appears by default because of how form libraries typically handle form inputs
    deserializer: value => value === '' ? undefined : value
  },
  scopedQuery: {
    defaultValue: {
      kql: '',
      filters: []
    }
  },
  startDate: {},
  endDate: {},
  timezone: {},
  recurring: {
    type: _hook_form_lib.FIELD_TYPES.TOGGLE,
    label: i18n.CREATE_FORM_REPEAT,
    defaultValue: false
  },
  recurringSchedule: (0, _recurring_schedule_form_schema.getRecurringScheduleFormSchema)({
    allowInfiniteRecurrence: false
  })
};