"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAiopsUiActions = registerAiopsUiActions;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _ui_actions = require("@kbn/ml-ui-actions/src/aiops/ui_actions");
var _create_change_point_chart = require("./create_change_point_chart");
var _open_change_point_ml = require("./open_change_point_ml");
var _categorize_field_actions = require("../components/log_categorization/categorize_field_actions");
var _create_pattern_analysis_action = require("./create_pattern_analysis_action");
var _create_log_rate_analysis_actions = require("./create_log_rate_analysis_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAiopsUiActions(uiActions, coreStart, pluginStart) {
  const openChangePointInMlAppAction = (0, _open_change_point_ml.createOpenChangePointInMlAppAction)(coreStart, pluginStart);
  const addChangePointChartAction = (0, _create_change_point_chart.createAddChangePointChartAction)(coreStart, pluginStart);
  const addPatternAnalysisAction = (0, _create_pattern_analysis_action.createAddPatternAnalysisEmbeddableAction)(coreStart, pluginStart);
  const addLogRateAnalysisAction = (0, _create_log_rate_analysis_actions.createAddLogRateAnalysisEmbeddableAction)(coreStart, pluginStart);
  uiActions.addTriggerAction(_public.ADD_PANEL_TRIGGER, addPatternAnalysisAction);
  uiActions.addTriggerAction(_public.ADD_PANEL_TRIGGER, addChangePointChartAction);
  uiActions.registerTrigger(_ui_actions.categorizeFieldTrigger);
  uiActions.addTriggerAction(_ui_actions.CATEGORIZE_FIELD_TRIGGER, (0, _categorize_field_actions.createCategorizeFieldAction)(coreStart, pluginStart));
  uiActions.addTriggerAction(_public2.CONTEXT_MENU_TRIGGER, openChangePointInMlAppAction);
  uiActions.addTriggerAction(_public.ADD_PANEL_TRIGGER, addLogRateAnalysisAction);
}