"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesModal = void 0;
var _react = require("react");
var _mlStringHash = require("@kbn/ml-string-hash");
var _common = require("@kbn/cases-plugin/common");
var _i18n = require("@kbn/i18n");
var _use_aiops_app_context = require("./use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a callback for opening the cases modal with provided attachment state.
 */
const useCasesModal = (embeddableType, title) => {
  const {
    cases
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const successMessage = (0, _react.useMemo)(() => {
    return _i18n.i18n.translate('xpack.aiops.useCasesModal.successMessage', {
      defaultMessage: '{title} added to case.',
      values: {
        title
      }
    });
  }, [title]);
  const selectCaseModal = cases === null || cases === void 0 ? void 0 : cases.hooks.useCasesAddToExistingCaseModal({
    successToaster: {
      content: successMessage
    }
  });
  return (0, _react.useCallback)(persistableState => {
    const persistableStateAttachmentState = {
      ...persistableState,
      // Creates unique id based on the input
      id: (0, _mlStringHash.stringHash)(JSON.stringify(persistableState)).toString()
    };
    if (!selectCaseModal) {
      throw new Error('Cases modal is not available');
    }
    selectCaseModal.open({
      getAttachments: () => [{
        type: _common.AttachmentType.persistableState,
        persistableStateAttachmentTypeId: embeddableType,
        persistableStateAttachmentState: JSON.parse(JSON.stringify(persistableStateAttachmentState))
      }]
    });
  }, [embeddableType, selectCaseModal]);
};
exports.useCasesModal = useCasesModal;