"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPatternAnalysisAvailable = getPatternAnalysisAvailable;
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPatternAnalysisAvailable(application) {
  return dataView => {
    return application.capabilities.aiops.enabled && dataView.isTimeBased() && dataView.fields.some(f => {
      var _f$esTypes;
      return (_f$esTypes = f.esTypes) === null || _f$esTypes === void 0 ? void 0 : _f$esTypes.includes(_fieldTypes.ES_FIELD_TYPES.TEXT);
    });
  };
}