"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogCategorizationAppState = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _use_data_source = require("../../hooks/use_data_source");
var _storage = require("../../types/storage");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _log_categorization_page = require("./log_categorization_page");
var _time_series_dataview_check = require("../../application/utils/time_series_dataview_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);

/**
 * Props for the LogCategorizationAppState component.
 */

const LogCategorizationAppState = ({
  dataView,
  savedSearch,
  appContextValue,
  showFrozenDataTierChoice = true
}) => {
  var _appContextValue$case, _appContextValue$case2, _appContextValue$case3;
  if (!dataView) return null;
  const warning = (0, _time_series_dataview_check.timeSeriesDataViewWarning)(dataView, 'log_categorization');
  if (warning !== null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warning);
  }
  const datePickerDeps = {
    ...(0, _lodash.pick)(appContextValue, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  const CasesContext = (_appContextValue$case = (_appContextValue$case2 = appContextValue.cases) === null || _appContextValue$case2 === void 0 ? void 0 : _appContextValue$case2.ui.getCasesContext()) !== null && _appContextValue$case !== void 0 ? _appContextValue$case : _react.default.Fragment;
  const casesPermissions = (_appContextValue$case3 = appContextValue.cases) === null || _appContextValue$case3 === void 0 ? void 0 : _appContextValue$case3.helpers.canUseCases();
  return /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appContextValue
  }, /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [],
    permissions: casesPermissions
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_log_categorization_page.LogCategorizationPage, null)))))));
};
exports.LogCategorizationAppState = LogCategorizationAppState;