"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CASES_TOAST_MESSAGES_TITLES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Titles for the cases toast messages
 */
const CASES_TOAST_MESSAGES_TITLES = exports.CASES_TOAST_MESSAGES_TITLES = {
  CHANGE_POINT_DETECTION: (viewType, chartsCount) => viewType === 'table' ? _i18n.i18n.translate('xpack.aiops.cases.changePointDetectionTableTitle', {
    defaultMessage: 'Change point table'
  }) : _i18n.i18n.translate('xpack.aiops.cases.changePointDetectionChartsTitle', {
    defaultMessage: 'Change point {chartsCount, plural, one {chart} other {charts}}',
    values: {
      chartsCount
    }
  }),
  LOG_RATE_ANALYSIS: _i18n.i18n.translate('xpack.aiops.cases.logRateAnalysisTitle', {
    defaultMessage: 'Log rate analysis'
  }),
  PATTERN_ANALYSIS: _i18n.i18n.translate('xpack.aiops.cases.logPatternAnalysisTitle', {
    defaultMessage: 'Log pattern analysis'
  })
};