"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMiniHistogramDataFromAggResponse = exports.getMiniHistogramAgg = exports.MINI_HISTOGRAM_BAR_TARGET = exports.MINI_HISTOGRAM_AGG_PREFIX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINI_HISTOGRAM_AGG_PREFIX = exports.MINI_HISTOGRAM_AGG_PREFIX = 'mini_histogram_';
const MINI_HISTOGRAM_BAR_TARGET = exports.MINI_HISTOGRAM_BAR_TARGET = 20;
const getMiniHistogramAgg = params => {
  return {
    mini_histogram: {
      histogram: {
        field: params.timeFieldName,
        interval: (params.end - params.start) / (MINI_HISTOGRAM_BAR_TARGET - 1),
        min_doc_count: 0,
        extended_bounds: {
          min: params.start,
          max: params.end
        }
      }
    }
  };
};
exports.getMiniHistogramAgg = getMiniHistogramAgg;
const getMiniHistogramDataFromAggResponse = (overallTimeSeries, aggReponse, index) => {
  var _overallTimeSeries$ma;
  return (_overallTimeSeries$ma = overallTimeSeries.map(overallTimeSeriesItem => {
    var _aggReponse$mini_hist, _overallTimeSeriesIte;
    const current = (_aggReponse$mini_hist = aggReponse[`${MINI_HISTOGRAM_AGG_PREFIX}${index}`].mini_histogram.buckets.find(bucket => bucket.key_as_string === overallTimeSeriesItem.key_as_string)) !== null && _aggReponse$mini_hist !== void 0 ? _aggReponse$mini_hist : {
      doc_count: 0
    };
    return {
      key: overallTimeSeriesItem.key,
      key_as_string: (_overallTimeSeriesIte = overallTimeSeriesItem.key_as_string) !== null && _overallTimeSeriesIte !== void 0 ? _overallTimeSeriesIte : '',
      doc_count_significant_item: current.doc_count,
      doc_count_overall: Math.max(0, overallTimeSeriesItem.doc_count - current.doc_count)
    };
  })) !== null && _overallTimeSeries$ma !== void 0 ? _overallTimeSeries$ma : [];
};
exports.getMiniHistogramDataFromAggResponse = getMiniHistogramDataFromAggResponse;