"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pager = void 0;
var _predicate = require("../predicate");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var Pager = exports.Pager = /*#__PURE__*/_createClass(function Pager(_totalItems, _itemsPerPage) {
  var _this = this;
  var initialPageIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  _classCallCheck(this, Pager);
  _defineProperty(this, "currentPageIndex", void 0);
  _defineProperty(this, "firstItemIndex", void 0);
  _defineProperty(this, "itemsPerPage", void 0);
  _defineProperty(this, "lastItemIndex", void 0);
  _defineProperty(this, "totalItems", void 0);
  _defineProperty(this, "totalPages", void 0);
  _defineProperty(this, "setTotalItems", function (totalItems) {
    _this.totalItems = totalItems;
    _this.update();
  });
  _defineProperty(this, "setItemsPerPage", function (itemsPerPage) {
    _this.itemsPerPage = itemsPerPage;
    _this.update();
  });
  _defineProperty(this, "isPageable", function () {
    return _this.firstItemIndex !== -1;
  });
  _defineProperty(this, "getTotalPages", function () {
    return _this.totalPages;
  });
  _defineProperty(this, "getCurrentPageIndex", function () {
    return _this.currentPageIndex;
  });
  _defineProperty(this, "getFirstItemIndex", function () {
    return _this.firstItemIndex;
  });
  _defineProperty(this, "getLastItemIndex", function () {
    return _this.lastItemIndex;
  });
  _defineProperty(this, "hasNextPage", function () {
    return _this.currentPageIndex < _this.totalPages - 1;
  });
  _defineProperty(this, "hasPreviousPage", function () {
    return _this.currentPageIndex > 0;
  });
  _defineProperty(this, "goToNextPage", function () {
    _this.goToPageIndex(_this.currentPageIndex + 1);
  });
  _defineProperty(this, "goToPreviousPage", function () {
    _this.goToPageIndex(_this.currentPageIndex - 1);
  });
  _defineProperty(this, "goToPageIndex", function (pageIndex) {
    _this.currentPageIndex = pageIndex;
    _this.update();
  });
  _defineProperty(this, "update", function () {
    if (_this.totalItems <= 0) {
      _this.totalPages = 0;
      _this.currentPageIndex = 0;
      _this.firstItemIndex = -1;
      _this.lastItemIndex = -1;
      return;
    }
    _this.totalPages = Math.ceil(_this.totalItems / _this.itemsPerPage);

    // Ensure the current page falls within our range of total pages.
    _this.currentPageIndex = Math.min(Math.max(0, _this.currentPageIndex), _this.totalPages - 1);

    // Find the range of visible items on the current page.
    _this.firstItemIndex = _this.currentPageIndex * _this.itemsPerPage;
    _this.lastItemIndex = Math.min(_this.firstItemIndex + _this.itemsPerPage, _this.totalItems) - 1;
  });
  if (!(0, _predicate.isNumber)(_totalItems) || isNaN(_totalItems)) {
    throw new Error('Please provide a number of totalItems');
  }
  if (!(0, _predicate.isNumber)(_itemsPerPage) || isNaN(_itemsPerPage)) {
    throw new Error('Please provide a number of itemsPerPage');
  }
  if (!(0, _predicate.isNumber)(initialPageIndex) || isNaN(initialPageIndex)) {
    throw new Error('Please provide a number of initialPageIndex');
  }
  this.currentPageIndex = initialPageIndex;
  this.firstItemIndex = -1;
  this.itemsPerPage = _itemsPerPage;
  this.lastItemIndex = -1;
  this.totalItems = _totalItems;
  this.totalPages = 0;
  this.update();
});