"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.EuiSelectableListItem = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _accessibility = require("../../accessibility");
var _badge = require("../../badge");
var _tool_tip = require("../../tool_tip");
var _selectable_list_item = require("./selectable_list_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "disabled", "checked", "isFocused", "showIcons", "prepend", "append", "allowExclusions", "onFocusBadge", "paddingSize", "role", "searchable", "textWrap", "toolTipContent", "toolTipProps", "aria-describedby"],
  _excluded2 = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function resolveIconAndColor(checked) {
  switch (checked) {
    case 'on':
      return {
        icon: 'check',
        color: 'text'
      };
    case 'off':
      return {
        icon: 'cross',
        color: 'text'
      };
    case 'mixed':
      return {
        icon: 'minus',
        color: 'text'
      };
    case undefined:
    default:
      return {
        icon: 'empty'
      };
  }
}
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 's'];
var EuiSelectableListItem = exports.EuiSelectableListItem = function EuiSelectableListItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    disabled = _ref.disabled,
    checked = _ref.checked,
    isFocused = _ref.isFocused,
    _ref$showIcons = _ref.showIcons,
    showIcons = _ref$showIcons === void 0 ? true : _ref$showIcons,
    prepend = _ref.prepend,
    append = _ref.append,
    allowExclusions = _ref.allowExclusions,
    _ref$onFocusBadge = _ref.onFocusBadge,
    onFocusBadge = _ref$onFocusBadge === void 0 ? true : _ref$onFocusBadge,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 's' : _ref$paddingSize,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'option' : _ref$role,
    searchable = _ref.searchable,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'truncate' : _ref$textWrap,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    _ariaDescribedBy = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSelectableListItem', {
    'euiSelectableListItem-isFocused': isFocused
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_selectable_list_item.euiSelectableListItemStyles);
  var cssStyles = [styles.euiSelectableListItem, styles.padding[paddingSize]];
  var textStyles = [styles.euiSelectableListItem__text, styles.textWrap[textWrap]];
  var optionIcon = (0, _react.useMemo)(function () {
    if (showIcons) {
      var _resolveIconAndColor = resolveIconAndColor(checked),
        icon = _resolveIconAndColor.icon,
        color = _resolveIconAndColor.color;
      return (0, _react2.jsx)(_icon.EuiIcon, {
        css: styles.euiSelectableListItem__icon,
        className: "euiSelectableListItem__icon",
        color: color,
        type: icon
      });
    }
  }, [showIcons, checked, styles]);
  var prependNode = (0, _react.useMemo)(function () {
    if (prepend) {
      return (0, _react2.jsx)("span", {
        css: styles.euiSelectableListItem__prepend,
        className: "euiSelectableListItem__prepend"
      }, prepend);
    }
  }, [prepend, styles]);
  var onFocusBadgeNode = (0, _react.useMemo)(function () {
    var defaultOnFocusBadgeProps = {
      'aria-hidden': true,
      iconType: 'returnKey',
      iconSide: 'left',
      color: 'hollow'
    };
    if (onFocusBadge === true) {
      return (0, _react2.jsx)(_badge.EuiBadge, _extends({
        className: "euiSelectableListItem__onFocusBadge"
      }, defaultOnFocusBadgeProps));
    } else if (typeof onFocusBadge !== 'boolean' && !!onFocusBadge) {
      var _children = onFocusBadge.children,
        _className = onFocusBadge.className,
        restBadgeProps = _objectWithoutProperties(onFocusBadge, _excluded2);
      return (0, _react2.jsx)(_badge.EuiBadge, _extends({
        className: (0, _classnames.default)('euiSelectableListItem__onFocusBadge', _className)
      }, defaultOnFocusBadgeProps, restBadgeProps), _children);
    }
  }, [onFocusBadge]);
  var showOnFocusBadge = !!(isFocused && !disabled && onFocusBadgeNode);
  var appendNode = (0, _react.useMemo)(function () {
    if (append || showOnFocusBadge) {
      return (0, _react2.jsx)("span", {
        css: styles.euiSelectableListItem__append,
        className: "euiSelectableListItem__append"
      }, append, " ", showOnFocusBadge ? onFocusBadgeNode : null);
    }
  }, [append, showOnFocusBadge, onFocusBadgeNode, styles]);
  var screenReaderText = (0, _react.useMemo)(function () {
    var state;
    var instructions;
    var screenReaderStrings = {
      checked: {
        state: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.checkedOption",
          default: "Checked option."
        }),
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.checkOptionInstructions",
          default: "To check this option, press Enter."
        })
      },
      unchecked: {
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.uncheckOptionInstructions",
          default: "To uncheck this option, press Enter."
        })
      },
      excluded: {
        state: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.excludedOption",
          default: "Excluded option."
        }),
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.excludeOptionInstructions",
          default: "To exclude this option, press Enter."
        })
      },
      mixed: {
        state: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOption",
          default: "Mixed (indeterminate) option."
        }),
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOptionInstructions",
          default: "To check this option for all, press Enter once."
        }),
        uncheckInstructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOptionUncheckInstructions",
          default: "To uncheck this option for all, press Enter twice."
        }),
        excludeInstructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOptionExcludeInstructions",
          default: "To exclude this option for all, press Enter twice."
        })
      }
    };
    switch (checked) {
      case 'on':
        state = screenReaderStrings.checked.state;
        instructions = allowExclusions ? screenReaderStrings.excluded.instructions : searchable ? screenReaderStrings.unchecked.instructions : undefined;
        break;
      case 'off':
        state = screenReaderStrings.excluded.state;
        instructions = screenReaderStrings.unchecked.instructions;
        break;
      case 'mixed':
        state = screenReaderStrings.mixed.state;
        instructions = (0, _react2.jsx)(_react.default.Fragment, null, screenReaderStrings.mixed.instructions, ' ', allowExclusions ? screenReaderStrings.mixed.excludeInstructions : screenReaderStrings.mixed.uncheckInstructions);
        break;
      case undefined:
      default:
        instructions = allowExclusions || searchable ? screenReaderStrings.checked.instructions : undefined;
        break;
    }
    return state || instructions ? (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", null, state || instructions ? '. ' : null, state, state && instructions ? ' ' : null, instructions)) : null;
  }, [checked, searchable, allowExclusions]);

  // aria-checked is intended to be used with role="checkbox" but
  // the MDN documentation lists it as a possibility for role="option".
  // See https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked
  // and https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/option_role
  var ariaChecked = (0, _react.useMemo)(function () {
    var rolesThatCanBeMixed = ['option', 'checkbox', 'menuitemcheckbox'];
    var rolesThatCanBeChecked = [].concat(rolesThatCanBeMixed, ['radio', 'menuitemradio', 'switch']);
    if (!rolesThatCanBeChecked.includes(role)) return undefined;
    switch (checked) {
      case 'on':
      case 'off':
        return true;
      case 'mixed':
        if (rolesThatCanBeMixed.includes(role)) {
          return 'mixed';
        } else {
          return false;
        }
      default:
        return false;
    }
  }, [role, checked]);
  var hasToolTip = !!toolTipContent && !disabled;
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    tooltipRef = _useState2[0],
    setTooltipRef = _useState2[1]; // Needs to be state and not a ref to trigger useEffect
  var _useState3 = (0, _react.useState)(_ariaDescribedBy),
    _useState4 = _slicedToArray(_useState3, 2),
    ariaDescribedBy = _useState4[0],
    setAriaDescribedBy = _useState4[1];

  // Manually trigger the tooltip on keyboard focus
  (0, _react.useEffect)(function () {
    if (!tooltipRef) return;
    if (isFocused) {
      tooltipRef.showToolTip();
    } else {
      tooltipRef.hideToolTip();
    }
  }, [isFocused, tooltipRef]);

  // Manually set the `aria-describedby` id on the <li> wrapper
  (0, _react.useEffect)(function () {
    if (tooltipRef) {
      var tooltipId = tooltipRef.state.id;
      setAriaDescribedBy((0, _classnames.default)(tooltipId, _ariaDescribedBy));
    }
  }, [tooltipRef, _ariaDescribedBy]);
  var content = (0, _react2.jsx)("span", {
    css: styles.euiSelectableListItem__content,
    className: "euiSelectableListItem__content"
  }, optionIcon, prependNode, (0, _react2.jsx)("span", {
    css: textStyles,
    className: "euiSelectableListItem__text"
  }, children, screenReaderText), appendNode);
  return (0, _react2.jsx)("li", _extends({
    role: role,
    "aria-disabled": disabled,
    "aria-checked": ariaChecked // Whether the item is "checked"
    ,
    "aria-selected": !disabled && isFocused // Whether the item has keyboard focus per W3 spec
    ,
    css: cssStyles,
    className: classes
  }, rest, {
    "aria-describedby": ariaDescribedBy
  }), hasToolTip ? (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({
    ref: setTooltipRef,
    content: toolTipContent,
    anchorClassName: "eui-fullWidth",
    position: "left"
  }, toolTipProps), content) : content);
};
EuiSelectableListItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  children: _propTypes.default.node,
  /**
       * Applies an icon and visual styling to activated items
       */
  checked: _propTypes.default.any,
  /**
       * Shows icons based on `checked` type
       */
  showIcons: _propTypes.default.bool,
  /**
       * Highlights the item for pseudo focus
       */
  isFocused: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  prepend: _propTypes.default.node,
  append: _propTypes.default.node,
  allowExclusions: _propTypes.default.bool,
  /**
       * When enabled by setting to either `true` or passing custom a custom badge,
       * shows a hollow badge as an append (far right) when the item is focused.
       * The default content when `true` is `↩ to select/deselect/include/exclude`
       */
  onFocusBadge: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    /**
       * Accepts any string from our icon library
       */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    /**
       * The side of the badge the icon should sit
       */
    iconSide: _propTypes.default.any,
    /**
       * Accepts either our palette colors (primary, success ..etc) or a hex value `#FFFFFF`, `#000`.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
    /**
       * Will override any color passed through the `color` prop.
       */
    isDisabled: _propTypes.default.bool,
    /**
       * Props passed to the close button.
       */
    closeButtonProps: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
       * Will apply an onclick to icon within the badge
       */
    iconOnClick: _propTypes.default.func,
    /**
       * Aria label applied to the iconOnClick button
       */
    iconOnClickAriaLabel: _propTypes.default.any,
    /**
       * Will apply an onclick to the badge itself
       */
    onClick: _propTypes.default.func,
    /**
       * Aria label applied to the onClick button
       */
    onClickAriaLabel: _propTypes.default.any,
    href: _propTypes.default.string,
    target: _propTypes.default.string,
    rel: _propTypes.default.string
  }).isRequired]),
  /**
       * Padding for the list items.
       */
  paddingSize: _propTypes.default.any,
  /**
       * Whether the `EuiSelectable` instance is searchable.
       * When true, the Space key will not toggle selection, as it will type into the search box instead. Screen reader instructions will be added instructing users to use the Enter key to select items.
       * When false, the Space key will toggle item selection. No extra screen reader instructions will be added, as Space to toggle is a generally standard for most select/checked elements.
       */
  searchable: _propTypes.default.bool,
  /**
       * Attribute applied the option `<li>`.
       * If set to a role that allows [aria-checked](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked),
       * `aria-checked` will be automatically configured.
       */
  role: _propTypes.default.any,
  /**
       * How to handle long text within the item.
       * Wrapping only works if virtualization is off.
       */
  textWrap: _propTypes.default.oneOf(["truncate", "wrap"]),
  /**
       * Optional custom tooltip content for the button
       */
  toolTipContent: _propTypes.default.node,
  /**
       * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
       */
  toolTipProps: _propTypes.default.any
};