"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSpinnerBorderColorsCSS = exports.euiLoadingSpinnerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
var _loadingSpinner = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(0deg);\n  }\n\n  to {\n    transform: rotate(359deg);\n  }\n"])));
var spinnerSizes = {
  s: 'm',
  m: 'base',
  l: 'l',
  xl: 'xl',
  xxl: 'xxl'
};
var euiSpinnerBorderColorsCSS = exports.euiSpinnerBorderColorsCSS = function euiSpinnerBorderColorsCSS(_ref) {
  var euiTheme = _ref.euiTheme,
    highContrastMode = _ref.highContrastMode;
  var colors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _colors$border = colors.border,
    border = _colors$border === void 0 ? euiTheme.components.loadingSpinnerBorder : _colors$border,
    _colors$highlight = colors.highlight,
    highlight = _colors$highlight === void 0 ? euiTheme.components.loadingSpinnerHighlight : _colors$highlight;
  if (highContrastMode === 'forced') {
    border = euiTheme.colors.lightestShade;
    highlight = euiTheme.colors.fullShade;
  }
  return "".concat(highlight, " ").concat(border, " ").concat(border, " ").concat(border);
};
var euiLoadingSpinnerStyles = exports.euiLoadingSpinnerStyles = function euiLoadingSpinnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var smallerBorderWidth = highContrastMode ? euiTheme.border.width.thick : (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
    return x * 1.5;
  });
  var largerBorderWidth = highContrastMode ? (0, _global_styling.mathWithUnits)(euiTheme.border.thick, function (x) {
    return x * 2;
  }) : euiTheme.border.width.thick;
  return {
    euiLoadingSpinner: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-block;border-radius:50%;border:", largerBorderWidth, " solid ", euiTheme.border.color, ";", (0, _global_styling.logicalShorthandCSS)('border-color', euiSpinnerBorderColorsCSS(euiThemeContext)), " ", (0, _high_contrast.preventForcedColors)(euiThemeContext), " ", _global_styling.euiCanAnimate, "{animation:", _loadingSpinner, " 0.6s infinite linear;};label:euiLoadingSpinner;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.s], euiTheme.size[spinnerSizes.s]), " border-width:", smallerBorderWidth, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.m], euiTheme.size[spinnerSizes.m]), " border-width:", smallerBorderWidth, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.l], euiTheme.size[spinnerSizes.l]), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.xl], euiTheme.size[spinnerSizes.xl]), ";;label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size[spinnerSizes.xxl], euiTheme.size[spinnerSizes.xxl]), ";;label:xxl;")
  };
};