"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _popover = require("../popover");
var _selectable = require("../selectable");
var _services = require("../../services");
var _index = require("./index");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
describe('EuiFilterGroup single filter example', function () {
  var SingleFilter = function SingleFilter() {
    var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      isFilterOn = _useState2[0],
      setIsFilterOn = _useState2[1];
    var toggleFilter = function toggleFilter() {
      setIsFilterOn(!isFilterOn);
    };
    return (0, _react2.jsx)(_index.EuiFilterGroup, null, (0, _react2.jsx)(_index.EuiFilterButton, {
      hasActiveFilters: isFilterOn,
      onClick: toggleFilter
    }, "Single filter"));
  };
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(SingleFilter, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when toggled on', function () {
      cy.get('button.euiButtonEmpty').first().realClick();
      cy.get('button.euiButtonEmpty').first().should('have.class', 'euiFilterButton-hasActiveFilters');
      cy.checkAxe();
    });
  });
});
describe('EuiFilterGroup filter with long name example', function () {
  var LongNameFilter = function LongNameFilter() {
    var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isFilterOn = _useState4[0],
      setIsFilterOn = _useState4[1];
    var toggleFilter = function toggleFilter() {
      setIsFilterOn(!isFilterOn);
    };
    return (0, _react2.jsx)(_index.EuiFilterGroup, null, (0, _react2.jsx)(_index.EuiFilterButton, {
      hasActiveFilters: isFilterOn,
      numFilters: 12,
      onClick: toggleFilter
    }, "Filter with a very long name"));
  };
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(LongNameFilter, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when toggled on', function () {
      cy.get('button.euiButtonEmpty').first().realClick();
      cy.get('button.euiButtonEmpty').first().should('have.class', 'euiFilterButton-hasActiveFilters');
      cy.checkAxe();
    });
  });
});
describe('EuiFilterGroup two filter example', function () {
  var ThreeOptionFilter = function ThreeOptionFilter() {
    var _useState5 = (0, _react.useState)(false),
      _useState6 = _slicedToArray(_useState5, 2),
      isOnFilterOn = _useState6[0],
      setIsOnFilterOn = _useState6[1];
    var _useState7 = (0, _react.useState)(false),
      _useState8 = _slicedToArray(_useState7, 2),
      isOffFilterOn = _useState8[0],
      setIsOffFilterOn = _useState8[1];
    var toggleOnFilter = function toggleOnFilter() {
      setIsOnFilterOn(!isOnFilterOn);
      setIsOffFilterOn(isOffFilterOn && !isOnFilterOn ? false : isOffFilterOn);
    };
    var toggleOffFilter = function toggleOffFilter() {
      setIsOffFilterOn(!isOffFilterOn);
      setIsOnFilterOn(isOnFilterOn && !isOffFilterOn ? false : isOnFilterOn);
    };
    return (0, _react2.jsx)(_index.EuiFilterGroup, null, (0, _react2.jsx)(_index.EuiFilterButton, {
      withNext: true,
      hasActiveFilters: isOnFilterOn,
      onClick: toggleOnFilter
    }, "Yes"), (0, _react2.jsx)(_index.EuiFilterButton, {
      withNext: true,
      hasActiveFilters: isOffFilterOn,
      onClick: toggleOffFilter
    }, "No"));
  };
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(ThreeOptionFilter, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when toggled on', function () {
      cy.get('button.euiButtonEmpty').first().realClick();
      cy.get('button.euiButtonEmpty').first().should('have.class', 'euiFilterButton-hasActiveFilters');
      cy.checkAxe();
    });
  });
});
describe('EuiFilterGroup multiselect example', function () {
  var MultiSelectFilter = function MultiSelectFilter() {
    var _useState9 = (0, _react.useState)(false),
      _useState10 = _slicedToArray(_useState9, 2),
      isPopoverOpen = _useState10[0],
      setIsPopoverOpen = _useState10[1];
    var _useState11 = (0, _react.useState)(false),
      _useState12 = _slicedToArray(_useState11, 1),
      withLoading = _useState12[0];
    var _useState13 = (0, _react.useState)(false),
      _useState14 = _slicedToArray(_useState13, 2),
      isLoading = _useState14[0],
      setIsLoading = _useState14[1];
    var onButtonClick = function onButtonClick() {
      if (withLoading && !isPopoverOpen) {
        setIsLoading(true);
      }
      setIsPopoverOpen(!isPopoverOpen);
    };
    var closePopover = function closePopover() {
      setIsPopoverOpen(false);
    };
    var filterGroupPopoverId = (0, _services.useGeneratedHtmlId)({
      prefix: 'filterGroupPopover'
    });
    var _useState15 = (0, _react.useState)([{
        label: 'Johann Sebastian Bach',
        checked: 'on'
      }, {
        label: 'Wolfgang Amadeus Mozart',
        checked: 'on'
      }, {
        label: 'Antonín Dvořák',
        checked: 'off'
      }, {
        label: 'Dmitri Shostakovich'
      }, {
        label: 'Felix Mendelssohn-Bartholdy'
      }, {
        label: 'Franz Liszt'
      }, {
        label: 'Franz Schubert'
      }, {
        label: 'Frédéric Chopin'
      }, {
        label: 'Georg Friedrich Händel'
      }, {
        label: 'Giuseppe Verdi'
      }]),
      _useState16 = _slicedToArray(_useState15, 2),
      items = _useState16[0],
      setItems = _useState16[1];
    var button = (0, _react2.jsx)(_index.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: onButtonClick,
      isSelected: isPopoverOpen,
      numFilters: items.filter(function (item) {
        return item.checked !== 'off';
      }).length,
      hasActiveFilters: !!items.find(function (item) {
        return item.checked === 'on';
      }),
      numActiveFilters: items.filter(function (item) {
        return item.checked === 'on';
      }).length
    }, "Composers");
    return (0, _react2.jsx)(_index.EuiFilterGroup, null, (0, _react2.jsx)(_popover.EuiPopover, {
      id: filterGroupPopoverId,
      button: button,
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      panelPaddingSize: "none"
    }, (0, _react2.jsx)(_selectable.EuiSelectable, {
      allowExclusions: true,
      searchable: true,
      searchProps: {
        placeholder: 'Filter list',
        compressed: true
      },
      "aria-label": "Composers",
      options: items,
      onChange: function onChange(newOptions) {
        return setItems(newOptions);
      },
      isLoading: isLoading,
      loadingMessage: "Loading filters",
      emptyMessage: "No filters available",
      noMatchesMessage: "No filters found"
    }, function (list, search) {
      return (0, _react2.jsx)("div", {
        style: {
          width: 300
        }
      }, (0, _react2.jsx)(_popover.EuiPopoverTitle, {
        paddingSize: "s"
      }, search), list);
    })));
  };
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(MultiSelectFilter, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when toggled on', function () {
      cy.get('button.euiButtonEmpty').first().realClick();
      cy.get('div[data-test-subj="euiSelectableList"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when filtering by keyboard interaction', function () {
      cy.realPress('Tab');
      cy.realPress('Enter');
      cy.get('div[data-test-subj="euiSelectableList"]').should('exist');
      cy.realPress('Tab');
      cy.repeatRealPress('ArrowDown', 3);
      cy.realPress('Enter');
      cy.get('li[aria-selected="true"]').find('span.euiSelectableListItem__text').should('have.text', 'Dmitri Shostakovich. Checked option. To exclude this option, press Enter.');
      cy.realPress('ArrowDown');
      cy.repeatRealPress('Enter');
      cy.get('li[aria-selected="true"]').find('span.euiSelectableListItem__text').should('have.text', 'Felix Mendelssohn-Bartholdy. Excluded option. To uncheck this option, press Enter.');
      cy.checkAxe();
    });
    it('has zero violations when filtering by searchbox', function () {
      cy.realPress('Tab');
      cy.realPress('Enter');
      cy.get('div[data-test-subj="euiSelectableList"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['m', 'a', 'r', 'k']);
      cy.get('div[data-test-subj="euiSelectableMessage"]').find('p').contains('No filters found').should('exist');
      cy.checkAxe();
    });
  });
});